<?php
if (get_field('products_used')) {
    $productsUsed = get_field('products_used');
    $productsUsedArray = [];
    global $post;
    $count = 0;
    foreach ($productsUsed as $post) {
        $count++;
        if ($count <= 3) {
            setup_postdata($post);
            $productImageId = get_post_thumbnail_id();
            $productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'general-tile') : [get_template_directory_uri() . "/dist/images/default-800-605.jpg"];
            $squareImage = get_field('square_image') ? wp_get_attachment_image_src(get_field('square_image'), 'award-square') : wp_get_attachment_image_src($productImageId, 'award-square');
            $productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: get_the_title();

            array_push($productsUsedArray, [
                'title' => get_the_title(),
                'url' => get_the_permalink(),
                'square_img' => $squareImage[0],
                'promo_img' => $productImage[0],
                'img_alt' => $productImageAlt,
            ]);
        }
    }
}
wp_reset_postdata();
?>
    <div class="recipe-container" itemscope itemtype="http://schema.org/Recipe">
        <section class="section section--illy-sheep ">
            <div class="container">
                <div class="row top-panel">
                    <div class="col-lg-5 content-wrapper">
                        <?php
                        if (function_exists('yoast_breadcrumb')) {
                            yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                        }
                        ?>

                        <h1 itemprop="name"><?php the_title(); ?></h1>
                        <meta itemprop="datePublished" content="<?= get_the_date(); ?>">

                        <?php

                        $posts = get_posts(array(
                            'posts_per_page'	=> -1,
                            'post_type'			=> 'review',
                            'meta_query'	=> array(
                                'relation'		=> 'AND',
                                array(
                                    'key'	 	=> 'is_recipe_review',
                                    'value'	  	=> '1',
                                    'compare' 	=> '=',
                                ),
                                array(
                                    'key'	  	=> 'recipe_id',
                                    'value'	  	=> get_the_ID(),
                                    'compare' 	=> '=',
                                ),
                            ),
                        ));

                        if( $posts ) { ?>
                                
                            <?php foreach( $posts as $post ) {
                                
                                setup_postdata( $post );

                                var_dump(get_the_ID());
                                var_dump(get_field('stars',get_the_ID()));
?>
                                <meta itemprop="review" content='
                                    "@type": "Review",
                                    "reviewRating": {
                                        "@type": "Rating",
                                        "ratingValue": "<?= get_field('stars',get_the_ID()) ?>",
                                        "bestRating": "5"
                                    },
                                    "author": {
                                        "@type": "Person",
                                        "name": "<?= get_the_title(); ?>"
                                    },
                                    "datePublished": "<?= get_the_date(); ?>",
                                    "reviewBody": "<?= get_the_content(); ?>"
                                '>
                            
                            <?php } ?>
                            
                            <?php wp_reset_postdata(); ?>
                        
                        <?php } ?>
                        
                        <meta itemprop="review" content='
                            "@type": "Review",
                            "reviewRating": {
                                "@type": "Rating",
                                "ratingValue": "4",
                                "bestRating": "5"
                            },
                            "author": {
                                "@type": "Person",
                                "name": "Julia Benson"
                            },
                            "datePublished": "2018-05-01",
                            "reviewBody": "This cake is delicious!",
                            "publisher": "The cake makery"
                        '>


                        <div class="content" itemprop="description">
                            <?php the_content(); ?>
                        </div>

                        <?php if (get_field('time_to_prepare')) {
                            $timeToPrepare = str_replace(' mins', '', get_field('time_to_prepare'));
                            ?>
                            <p class="prep-time" itemprop="prepTime" content="PT<?= $timeToPrepare; ?>M">Prep time:
                                <span><?php the_field('time_to_prepare'); ?></span></p>
                        <?php } ?>

                        <?php if (get_field('cooking_time')) {
                            $cookTime = str_replace(' mins', '', get_field('cooking_time'));
                            ?>
                            <p class="cook-time" itemprop="cookTime" content="PT<?= $timeToPrepare; ?>M">Cooking time:
                                <span><?= $cookTime; ?></span></p>
                        <?php } ?>

                        <?php if (get_field('serves')) { ?>
                            <p class="serves" itemprop="recipeYield">Serves: <span><?php the_field('serves'); ?></span>
                            </p>
                        <?php } ?>
                    </div>
                    <div class="col-lg-7">
                        <?php
                        $recipeImageId = get_post_thumbnail_id();
                        $recipeImage = $recipeImageId ? wp_get_attachment_image_src($recipeImageId, 'general-tile') : "";
                        $recipeImageAlt = get_post_meta(get_post_thumbnail_id($recipeImageId), '_wp_attachment_image_alt', true) ?: get_the_title();

                        if ($recipeImage) {
                            ?>
                            <img itemprop="image" class="img-fluid recipe-main-img" src="<?= $recipeImage[0]; ?>"
                                 alt="<?= $recipeImageAlt; ?>"/>
                            <?php
                        }

                        if (isset($productsUsedArray) && $productsUsedArray) { ?>
                            <div class="products-used-circles tile--caption-recipe-circles">
                                <?php foreach ($productsUsedArray as $productUsed) { ?>
                                    <a href="<?= $productUsed['url']; ?>" class="products-used-circle">
                                        <img class="img-fluid" src="<?= $productUsed['square_img']; ?>"
                                             alt="<?= $productUsed['img_alt']; ?>"/>
                                    </a>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
        <a class="standout-link standout-link-white standout-link--write-a-review text-center" href="<?php echo esc_url(home_url('/')); ?>review-our-recipes?recipeId=<?= get_the_id(); ?>">
            <span class="hover-prompt">love this product?</span>
            <span class="lead-text"><span>sH</span>are your thoughts!</span>
        </a>
        <section class="section section--white section--white--tint-white">
            <div class="container">
                <div class="row cooking-panel">
                    <div class="col-lg-4 order-lg-1">
                        <?php if (get_field('ingredients')) { ?>
                            <h4>ingredients</h4>
                            <?php
                            $ingredients = get_field('ingredients');
                            $ingredients = explode("\n", get_field('ingredients'));
                            foreach ($ingredients as $ingredient) {
                                if ($ingredient != '') {
                                    echo '<p itemprop="recipeIngredient">' . strip_tags($ingredient) . '</p>';
                                }
                            }
                            ?>
                        <?php } ?>

                        <?php if (isset($productsUsedArray) && $productsUsedArray) { ?>
                            <div class="products-used-wrapper">
                                <?php foreach ($productsUsedArray as $productUsed) { ?>
                                    <a href="<?= $productUsed['url']; ?>" class="products-used">
                                        <img class="img-fluid" src="<?= $productUsed['promo_img']; ?>"
                                             alt="<?= $productUsed['img_alt']; ?>"/>
                                    </a>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    </div>
                    <?php if (get_field('method')) { ?>
                        <div class="col-lg-7 order-lg-3 method" itemprop="recipeInstructions">
                            <h4>Method</h4>
                            <?php the_field('method'); ?>
                        </div>
                    <?php } ?>
                    <div class="col-lg-1 order-lg-2 print-share-wrapper">
                        <button class="print-recipe" id="print-recipe">
                            Print
                            <i class="fas fa-print"></i>
                        </button>

                        <p class="share">Share
                        <div class="addthis_inline_share_toolbox"></div>
                        </p>
                    </div>
                </div>
            </div>
        </section>
        <section class="section">
            <div class="container">
                <?php
                if (get_field('related_videos') === true) {
                    if (have_rows('related_video_urls')) {
                        ?>
                        <div class="related-videos">
                            <div class="row">
                                <div class="col-12 col-lg-4 pr-lg-0">
                                    <div class="swiper-arrows">
                                        <!-- Add Arrows -->
                                        <div class="swiper-button-next"></div>
                                        <div class="swiper-button-prev"></div>
                                        <div class="mask">
                                            <h2><?php the_field('related_videos_title'); ?></h2>
                                            <span><?php the_field('related_videos_caption'); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-8 pl-lg-0">
                                    <section class="section--nav">
                                        <div class="swiper-container swiper-recipe-videos">
                                            <div class="swiper-wrapper">
                                                <?php
                                                while (have_rows('related_video_urls')) {
                                                    the_row();
                                                    $videoImgId = get_sub_field('video_related_image');
                                                    $videoImg = $videoImgId ? wp_get_attachment_image_src($videoImgId, 'news-archive') : "";
                                                    $videoImgAlt = get_post_meta(get_post_thumbnail_id($videoImgId), '_wp_attachment_image_alt', true) ?: get_the_title();

                                                    ?>
                                                    <div class="swiper-slide">
                                                        <a href="<?php the_sub_field('video_url'); ?>">
                                                            <img src="<?= $videoImg[0]; ?>" alt="<?= $videoImgAlt; ?>"/>
                                                        </a>
                                                    </div>
                                                <?php } ?>

                                            </div>

                                        </div>
                                    </section>
                                </div>
                            </div>
                        </div>
                    <?php }
                } ?>

                <?php if (get_field('you_may_also_like')) { ?>
                    <div class="row related-recipes">
                        <div class="col-12">
                            <h2>You may also like</h2>
                        </div>

                        <?php
                        $recipes = get_field('you_may_also_like');
                        foreach ($recipes as $post) {
                            setup_postdata($post);
                            ?>
                            <div class="col-lg-4">
                                <?php get_template_part('templates/parts/tile-caption-recipe'); ?>
                            </div>
                        <?php }
                        wp_reset_postdata(); ?>
                    </div>
                <?php } ?>
            </div>
        </section>
    </div>
<?php
include(locate_template('templates/recipe/print.php'));
Blue2\Scruffy\Utils::flexibleLoop();