<?php
/**
 * Customer processing order email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-processing-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates/Emails
 * @version     2.5.0
 */

if (! defined('ABSPATH')) {
    exit;
}

$isDelivery = Blue2\Scruffy\Controllers\WoocommerceController::getOrderType($order) == 'ship';

if ($isDelivery) {
    include(locate_template('woocommerce/emails/email-header-confirmation-delivery.php'));

    if (have_rows('confirmation_email_delivery_flexible_content', 'option')) {
        while (have_rows('confirmation_email_delivery_flexible_content', 'option')) {
            the_row();
            include(locate_template('woocommerce/emails/parts/' . get_row_layout() . '.php'));
        }
    }

    include(locate_template('woocommerce/emails/email-footer-confirmation.php'));
} else {
    include(locate_template('woocommerce/emails/email-header-confirmation.php'));

    if (have_rows('confirmation_email_flexible_content', 'option')) {
        while (have_rows('confirmation_email_flexible_content', 'option')) {
            the_row();
            include(locate_template('woocommerce/emails/parts/' . get_row_layout() . '.php'));
        }
    }

    include(locate_template('woocommerce/emails/email-footer-confirmation.php'));
}
