<?php 
$bgImg = get_sub_field('large_image') ? wp_get_attachment_image_src(get_sub_field('large_image'), 'fullwidth-banner') : [];
if(get_sub_field('content_position') === 'left') {
    $orderVideo = "order-2";
    $orderContent = "order-1";
} else {
    $orderVideo = "order-1";
    $orderContent = "order-2";
}
?>
<section class="section section--impact-area" style="background-image:url(<?= $bgImg[0]; ?>" >
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-6 single-video <?= $orderVideo; ?>">
                <?php if(get_sub_field('youtube_code')) { ?>
                    <div class="embed-responsive embed-responsive-16by9">
                        <iframe class="embed-responsive-item" width="100%" src="https://www.youtube.com/embed/<?php the_sub_field('youtube_code'); ?>" 
                            frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen>
                        </iframe>
                    </div>
                <?php } ?>
            </div>
            <div class="col-12 col-lg-6 <?= $orderContent; ?>">
                <?php if(get_sub_field('content') || get_sub_field('call_to_action_url') && get_sub_field('call_to_action_label')) { ?>
                    <div class="content-wrapper">                    
                        <?php 
                        if(get_sub_field('content')) {
                            the_sub_field('content');
                        } ?>

                        <?php if(get_sub_field('call_to_action_url') && get_sub_field('call_to_action_label')) { ?>
                            <a class="btn btn-graphic" href="<?php the_sub_field('call_to_action_url'); ?>"><?php the_sub_field('call_to_action_label'); ?></a>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>