<?php
global $post;
if(get_sub_field('recipe')) {
    $post = get_sub_field('recipe');
} elseif(get_field('recipe')) {
	$post = get_field('recipe');
}

setup_postdata( $post ); 
$recipeImageId = get_field('featured_image') ?: get_post_thumbnail_id();
$recipeImage = $recipeImageId ? wp_get_attachment_image_src($recipeImageId, 'fullwidth-banner') : 
[get_template_directory_uri() . "/dist/images/default-800-605.jpg"];
$recipeImageAlt = get_post_meta(get_post_thumbnail_id($recipeImageId), '_wp_attachment_image_alt', true) ?: get_the_title();

if(get_field('products_used')) {
    $productsUsed = get_field('products_used'); 
	$productsUsedArray = [];
	$count = 0; 
    foreach($productsUsed as $products) { 
		$count++; 
		if($count <= 3) {
			$productImageId = get_post_thumbnail_id($products->ID);
			// $squareImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'award-square') : [get_template_directory_uri() . "/dist/images/default-800-605.jpg"];
			$squareImage = get_field('square_image', $products->ID) ? wp_get_attachment_image_src(get_field('square_image', $products->ID), 'award-square') : wp_get_attachment_image_src($productImageId, 'award-square');
			$productImageAlt = get_post_meta(get_post_thumbnail_id(get_field('square_image', $products->ID)), '_wp_attachment_image_alt', true) ?: get_the_title();
			
			array_push($productsUsedArray, [
				'title' => get_the_title($products->ID),
				'url' => get_the_permalink($products->ID),
				'square_img' => $squareImage[0],
				'img_alt' => $productImageAlt
			]);
		}
    }
} 
?>

<figure class="tile tile--caption tile--img-hover tile--caption-recipe featured-recipe">
	<a href="<?php the_permalink(); ?>">
		<img class="img-fluid" src="<?= $recipeImage[0]; ?>" alt="<?= $recipeImageAlt; ?>" />

		<figcaption class="btn-graphic">
			<h3><?php the_title(); ?></h3>
    
		</figcaption>

	</a>
</figure>

<?php if(isset($productsUsedArray) && $productsUsedArray) { ?>

	<div class="products-used-circles tile--caption-recipe-circles">
		<?php 
		foreach($productsUsedArray as $productUsed) { 
			?>
			<a href="<?= $productUsed['url']; ?>" class="products-used-circle">
				<img class="img-fluid" src="<?= $productUsed['square_img']; ?>" alt="<?= $productUsed['img_alt'];?>"/>
			</a>
		<?php 
			} 
		?>
	</div>

<?php } ?>

<?php wp_reset_postdata();