<?php

$title = get_sub_field("title") ?? "";
$link = get_sub_field("link") ?? "";
$linkText = get_sub_field("link_text") ?? "";

$useCustomLinks = get_sub_field("use_custom_links") ?? "";
$sectionBSClass = get_sub_field("section_bs_class") ?? "";


if ($useCustomLinks) {
    if(get_sub_field('custom_links')) {
        $customLinks = get_sub_field('custom_links');
        ?>
        <section class="section section--product-slider-supermarket range-slider <?= $sectionBSClass; ?>" >
            <?php
            if ($title !== "") {
            ?>
                <div class="container">
                    <div class="row">
                        <h2 class="accent"><?= $title !== "" ? $title : "Browse Our Range"; ?></h2>
                    </div>
                </div>
            <?php
            }
            ?>
            <div class="container-fluid">
                <div class="row">
                    <div class="swiper-products-supermarket-range-slider swiper-container">
                        <div class="swiper-wrapper">
                            <?php
                                foreach($customLinks as $customLink) {
                                    // var_dump($customLink);
                                    $productText = $customLink['text'];
                                    $productImage = $customLink['image'];
                                    $productLink = $customLink['link'];                                    ?>
                                    <div class="swiper-slide">
                                        <a href="<?= $productLink; ?>">
                                            <img src="<?= $productImage; ?>" alt="" />
                                            <p><?= $productText; ?></p>
                                        </a>
                                    </div>
                            <?php }?>
                        </div>
                        <!-- Add Arrows -->
                        <div class="swiper-button-next swiper-button-next--range"></div>
                        <div class="swiper-button-prev swiper-button-prev--range"></div>
                    </div>
                </div>
            </div>
            <?php if($linkText !== "") { ?>
                <a class="range-slider-cta" href="<?= $link ?>"><span class="cac-btn-graphic--alt btn-graphic--alt accent"><?= $linkText ?></span></a>
            <?php } ?>
        </section>
    <?php }
} else {
    if(get_sub_field('categories')) {
        $categories = get_sub_field('categories');
        ?>
        <section class="section section--product-slider-supermarket range-slider <?= $sectionBSClass; ?>" >
            <?php
            if (!is_archive("supermarket")) {
            ?>
                <div class="container">
                    <div class="row">
                        <h2 class="accent"><?= $title !== "" ? $title : "Browse Our Range"; ?></h2>
                    </div>
                </div>
            <?php
            }
            ?>
            <div class="container-fluid">
                <div class="row">
                    <div class="swiper-products-supermarket-range-slider swiper-container">
                        <div class="swiper-wrapper">
                            <?php
                                foreach($categories as $category) {
                                    $productImageId = get_term_meta( $category->term_id, 'thumbnail_id', true );
                                    $productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'award-square') : [get_template_directory_uri() . "/dist/images/product-package-240-175.png"];
                                    $productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: $category->name;
                                    ?>
                                    <div class="swiper-slide">
                                        <a href="<?= get_term_link($category->term_id); ?>">
                                            <img src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
                                            <p><?= $category->name; ?></p>
                                        </a>
                                    </div>
                            <?php }?>
                        </div>
                        <!-- Add Arrows -->
                        <div class="swiper-button-next swiper-button-next--range"></div>
                        <div class="swiper-button-prev swiper-button-prev--range"></div>
                    </div>
                </div>
            </div>
            <?php if($linkText !== "") { ?>
                <a class="range-slider-cta" href="<?= $link ?>"><span class="cac-btn-graphic--alt btn-graphic--alt accent"><?= $linkText ?></span></a>
            <?php } ?>
        </section>
    <?php } wp_reset_postdata();
}