<?php 
$supermarketImg =  wp_get_attachment_image_src(get_field('supermarket_menu_image', 'option'), 'thin-tile');
$supermarketUrl = get_field('supermarket_menu_url', 'option');
$localButcherImg =  wp_get_attachment_image_src(get_field('local_butcher_menu_image', 'option'), 'thin-tile');
$localButcherUrl = get_field('local_butcher_menu_url', 'option');
$companyImg =  wp_get_attachment_image_src(get_field('our_company_menu_image', 'option'), 'thin-tile');
$companyUrl = get_field('our_company_menu_url', 'option');
?>
<div id="hamburger-content" class="navigation">
    <div class="row no-gutters">
        <div class="col-md-8 col-xl-9">
            <div class="row nav-menus no-gutters">
                <div class="col-5 d-block d-sm-none mobile-feature">
                    <a href="<?php the_field('blog_url', 'options'); ?>">
                        <img src="<?php echo get_template_directory_uri(); ?>/dist/images/our-blog-x2-white.png" alt="Our Blog" /> 
                        Explore Articles
                   </a>
                </div>
                <div class="col-5 d-block d-sm-none mobile-feature">
                    <a href="<?php the_field('click_&_collect_url', 'options'); ?>">
                        <img src="<?php echo get_template_directory_uri(); ?>/dist/images/shop-now-x2-white.png" alt="Shop Now" /> 
                        Click &amp; Collect
                    </a>
                </div>
                <div class="col-xl-4 category-menu">
                    <a class="title" href="<?= $supermarketUrl; ?>">
                        <span>Supermarket Range</span>
                        <img class="img-fluid" src="<?= $supermarketImg[0]; ?>" alt="Supermarkets" />
                    </a>
                    <?php
                    if (has_nav_menu('hamburger_menu_supermarkets')) {
                        wp_nav_menu(['theme_location' => 'hamburger_menu_supermarkets', 'menu_id' => 'navigation1']);
                    }
                    ?>
                </div>
                <div class="col-xl-4 category-menu">
                    <a class="title" href="<?= $localButcherUrl; ?>">
                        <span>Local Butcher</span>
                        <img class="img-fluid" src="<?= $localButcherImg[0]; ?>" alt="Local Butcher" />
                    </a>
                    <?php
                    if (has_nav_menu('hamburger_menu_local_butchers')) {
                        wp_nav_menu(['theme_location' => 'hamburger_menu_local_butchers', 'menu_id' => 'navigation2']);
                    }
                    ?>
                </div>
                <div class="col-xl-4 category-menu">
                    <a class="title" href="<?= $companyUrl; ?>">
                        <span>Our Company</span>
                        <img class="img-fluid" src="<?= $companyImg[0]; ?>" alt="Our Company" />
                    </a>
                    <?php
                    if (has_nav_menu('hamburger_menu_our_company')) {
                        wp_nav_menu(['theme_location' => 'hamburger_menu_our_company', 'menu_id' => 'navigation3']);
                    }
                    ?>
                </div>
                <img class="stamp" src="<?php echo get_template_directory_uri(); ?>/dist/images/food-to-cherish.png" alt="food to cherish" />
                
            </div>
        </div>   
        <div class="col-12 col-md-4 col-xl-3 right-col">
            <div class="social-title">
                <span class="accent"><span>sH</span>are your creations with us!</span>
                <a href="https://www.instagram.com/explore/tags/simonhowie/?hl=en" target="_blank">
                &#35;simonhowie
                </a>
            </div>
            <div class="social-stream aside-native-scroll">
                <div class="aside-wrapper">
                    <?php get_template_part('templates/parts/social-media-menu'); ?>
                </div>
            </div>
        </div>
    </div>
</div>