import Swiper from 'swiper';
import 'swiper/dist/css/swiper.min.css';

const common = () => {
    const bannerIniCheck = setInterval(function() {
        if ($('.section--banner-slider')) {
            if ($('.section--banner-slider').width() > 992) {
                let bannerHeight = $('.slide-no--1 .banner-height-el').outerHeight();
                if ($('.slide-no--1 .banner-height-el').hasClass('banner-height-el--centered')) {
                    bannerHeight = bannerHeight + 150;
                }
                if (bannerHeight > 100 && bannerHeight < 600) {
                    clearInterval(bannerIniCheck);
                    $('.banner-slider-swiper .swiper-wrapper').css('height',bannerHeight);
                }
            } else {
                $('.banner-slider-swiper .swiper-wrapper').css('height','auto');
            }
        }
    }, 100);
    // Make sure this interval is cleared after a few seconds...
    setTimeout(function() {
        clearInterval(bannerIniCheck);
    }, 7000);

    $(window).on('load', () => {
        $('body').removeClass('fade-out');
        $(window).on('beforeunload', () => {
            $('body').addClass('fade-out-anim');
        });
    });
    $('.removeFadeOut').click(() => {
        setTimeout(() => {
            $('body').removeClass('fade-out-anim');
        }, 750);
    });

    function ieVersion(uaString) {
        const match = /\b(MSIE |Trident.*?rv:|Edge\/)(\d+)/.exec(uaString);
        if (match) {
            return parseInt(match[2], 0); // eslint-disable-line
        }
    }
    const isIe = ieVersion(navigator.userAgent);
    if (isIe > 9 && isIe < 12) {
        const browserAlert =
            '<div class="alert alert-warning z-top">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</div>';
        $('header#top').prepend(browserAlert);
    }

    /** Settings for the Swiper used on all pages */

    // Alternative settings for Landing page template.
    let mySwiper1;
    let mySwiper2;
    let swiperSellers;
    if ($('body.page-template-template-landing-page')) {
        mySwiper2 = new Swiper('.swiper-products-supermarket', {
            slidesPerView: 8,
            spaceBetween: 10,
            loop: true,
            navigation: {
                nextEl: '.swiper-button-next--category',
                prevEl: '.swiper-button-prev--category',
            },
            breakpoints: {
                1750: {
                    slidesPerView: 8,
                    spaceBetween: 10,
                },
                1600: {
                    slidesPerView: 7,
                    spaceBetween: 10,
                },
                1500: {
                    slidesPerView: 6,
                    spaceBetween: 10,
                },
                1350: {
                    slidesPerView: 5,
                    spaceBetween: 10,
                },
                640: {
                    slidesPerView: 3,
                    spaceBetween: 10,
                },
                480: {
                    slidesPerView: 2,
                    spaceBetween: 10,
                },
                320: {
                    slidesPerView: 1,
                    spaceBetween: 10,
                },
            },
            autoplay: {
                delay: 4000,
            },
        });
        mySwiper1 = new Swiper('.swiper-products-supermarket-range-slider', {
            slidesPerView: 1,
            navigation: {
                nextEl: '.swiper-button-next--range',
                prevEl: '.swiper-button-prev--range',
            },
            breakpoints: {
                2000: {
                    slidesPerView: 5,
                    spaceBetween: 10,
                },
                640: {
                    slidesPerView: 3,
                    spaceBetween: 10,
                },
                480: {
                    slidesPerView: 2,
                    spaceBetween: 10,
                },
                320: {
                    slidesPerView: 1,
                    spaceBetween: 10,
                },
            },
            autoplay: {
                delay: 4000,
            },
            loop: true,
        });
        setTimeout(function() {
            swiperSellers = new Swiper('.swiper-sellers', {
                autoplay: {
                    delay: 7000,
                },
                loop: true,
                slidesPerView: 1,
                navigation: {
                    nextEl: '.swiper-button-next--sellers',
                    prevEl: '.swiper-button-prev--sellers',
                },
            });
        }, 4000);
    } else {
        mySwiper2 = new Swiper('.swiper-products-supermarket', {
            loop: false,
            slidesPerView: 5,
            spaceBetween: 10,
            slidesOffsetAfter: 120,
            navigation: {
                nextEl: '.swiper-button-next--range',
                prevEl: '.swiper-button-prev--range',
            },
            breakpoints: {
                320: {
                    slidesPerView: 1,
                    spaceBetween: 10,
                },
                480: {
                    slidesPerView: 2,
                    spaceBetween: 10,
                },
                640: {
                    slidesPerView: 3,
                    spaceBetween: 10,
                },
            },
        });
        swiperSellers = new Swiper('.swiper-sellers', {
            loop: true,
            slidesPerView: 1,
            navigation: {
                nextEl: '.swiper-button-next--sellers',
                prevEl: '.swiper-button-prev--sellers',
            },
        });
    }
    // mySwiper;
    // swiperSellers;

    const reviewSwiper = new Swiper('.review-swiper', {
        loop: true,
        slidesPerView: 1,
        navigation: {
            nextEl: '.swiper-button-next--review',
            prevEl: '.swiper-button-prev--review',
        },
    });
    reviewSwiper;

    const bannerSliderSwiper = new Swiper('.banner-slider-swiper', {
        observer: true,
        observeParents: true,
        loop: true,
        slidesPerView: 1,
        navigation: {
            nextEl: '.swiper-button-next--banner',
            prevEl: '.swiper-button-prev--banner',
        },
        pagination: {
            el: '.swiper-pagination',
            type: 'bullets',
            clickable: true,
        },
    });
    bannerSliderSwiper;

    const checkBannerSize = function() {
        if ($('.section--banner-slider').width() > 992) {
            setTimeout(function() {
                let bannerHeight = $('.swiper-slide-active .banner-height-el').outerHeight();
                if ($('.swiper-slide-active .banner-height-el').hasClass('banner-height-el--centered')) {
                    bannerHeight = bannerHeight + 150;
                }
                $('.banner-slider-swiper .swiper-wrapper').css('height',bannerHeight);
            }, 200);
        }
    };
    bannerSliderSwiper.on('slideChange init', function() {
        if ($('.banner-slider-swiper')) {
            checkBannerSize();
        }
    });
    window.addEventListener('resize', function(event) {
        if ($('.banner-slider-swiper')) {
            checkBannerSize();
        }
    }, true);
    window.addEventListener('load', function(event) {
        if ($('.banner-slider-swiper')) {
            checkBannerSize();
        }
    });

    $('.search-trigger').click(() => {
        $('.search-bar').toggleClass('open');
        $('.search-trigger .svg-inline--fa').toggleClass('fa-search');
        $('.search-trigger .svg-inline--fa').toggleClass('fa-times');
    });
    $('.scrollNav').on('click', function(event) {
        if (this.hash !== '') {
            event.preventDefault();
            const hash = this.hash;
            $('html, body').animate(
                {
                    scrollTop: $(hash).offset().top,
                },
                900,
                () => {
                    if (hash !== '#Top') {
                        window.location.hash = hash;
                    }
                }
            );
        }
    });
    $(document).scroll(function() {
        if ($(this).scrollTop() > 20) {
            $('body').addClass('past-header');
        } else {
            $('body').removeClass('past-header');
        }
    });
    $('.woocommerce-form-login').css('display', 'flex');
    // }
};

export default common;
