<?php 

$sectionBSClass = get_sub_field("section_bs_class") ?? "";

if (is_archive("supermarket")) {
    $class="-fluid";
} else {
    $class="";
}

$title = get_sub_field("title") ?? "";

if(get_sub_field('categories')) { 
    $categories = get_sub_field('categories');
    ?>
    <section class="section section--product-slider-supermarket <?= $sectionBSClass; ?>" >
        <div class="container">
            <div class="row">
                <?php if ($title !== "") { ?>
                    <h1><?= $title ?></h1>
                <?php }else{ ?>
                    <h1>In the Supermarkets</h1>
                <?php } ?>
            </div>
        </div>
        <div class="container<?= $class ?>">
            <div class="row">
                <div class="swiper-container swiper-products-supermarket">
                    <div class="swiper-wrapper">
                        <?php 
                        foreach($categories as $category) { 
                            $productImageId = get_term_meta( $category->term_id, 'thumbnail_id', true );
                            $productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'award-square') : [get_template_directory_uri() . "/dist/images/product-package-240-175.png"];
                            $productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: $category->name;
                            ?>
                            <div class="swiper-slide">
                                <a href="<?= get_term_link($category->term_id); ?>">
                                    <img src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
                                    <p><?= $category->name; ?></p>
                                </a>
                            </div>
                        <?php } ?>
                    </div>

                    <!-- Add Arrows -->
                    <div class="swiper-button-next swiper-button-next--category"></div>
                    <div class="swiper-button-prev swiper-button-prev--category"></div>
                    <div class="mask"><a href="/where-to-buy"><i class="fas fa-map-marked-alt"></i><p>Where to buy map</p></a></div>
                </div>
            </div>
        </div>
    </section>
<?php } wp_reset_postdata();