<section class="section section-vacancies-archive">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                <?php
                if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                }
                ?>
                <h1>Jobs</h1>
                <p><?= get_field('vacancy_content', 'option'); ?></p>
                <div class="dropdown">
                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Department
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                        <a class="dropdown-item" href="/jobs/">All Departments</a>
                        <?php
                        $categories = get_terms(['taxonomy' => 'department_jobs']);
                        foreach ($categories as $category) { ?>
                            <a class="dropdown-item"
                               href="/department_jobs/=<?= $category->slug; ?>"><?= $category->name; ?></a>
                        <?php } ?>
                    </div>
                </div>

            </div>
            <div class="col-lg-8">
                <?php 
                $bgImg = get_field('vacancy_image', 'option');
                $bgImgAlt = get_post_meta(get_post_thumbnail_id($bgImg), '_wp_attachment_image_alt', true) ?: '';
                $bgImg = $bgImg ? wp_get_attachment_image_src($bgImg, 'large') : ['/content/themes/simonhowie-theme/dist/images/click-and-collect-image-style.png'];
                ?>
                <img class="img-fluid" src="<?= $bgImg[0]; ?>" alt="<?= $bgImgAlt; ?>">
            </div>
        </div>
        <div class="row">
            <?php
            if (!have_posts()) { ?>
                <div class="col-lg-12">
                    <h3>There are currently no vacancies please check back later.</h3>
                </div>
            <?php } else {
                Blue2\Scruffy\Utils::archiveLoop();
            }?>
        </div>
    </div>
</section>
