<?php $bgImg = wp_get_attachment_image_src(get_field('recipe_background_image', 'option'), 'fullwidth'); ?>
<section class="section" <?php if($bgImg) { echo 'style="background-image: url(' . $bgImg[0] . ')"'; } ?>>
    <div class="container">
        <div class="row">

            <?php
            if(!(isset($_GET['time']))) { ?>
                <div class="col-xl-7 order-1 order-xl-1">
                    <?php if (function_exists('yoast_breadcrumb')) {
                        yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                    } ?>
                    <?php // if(is_post_type_archive('recipe')) { } ?>
                    <h1><?php the_field('recipe_archive_title', 'options'); ?></h1>
                    <?php if(get_field('recipe_archive_content', 'options')) {
                        the_field('recipe_archive_content', 'options');
                    } ?>
                </div>

                <div class="col-xl-5 order-4 order-xl-2">
                    <?php Blue2\Scruffy\Utils::featuredPost('recipe'); ?>
                </div>
            <?php } else { 
                $term = get_term_by('slug', $_GET['time'], 'time');
                ?>
                <div class="col-12">
                    <h1><?= $term->name; ?></h1>
                </div>

            <?php } ?>
            
            <div class="col-xl-4 order-2 order-xl-3">
                <div class="dropdown">

                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Filter by time
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                        <a class="dropdown-item" href="/recipes">All</a>
                        <?php
                        $times = get_terms([
                            'taxonomy' => 'time', 
                            'hide_empty' => true, 
                            'orderby' => 'meta_value_num',
                            'meta_query' => [[
                                'key' => 'order',
                                'type' => 'NUMERIC',
                            ]],
                            ]); 
                        foreach ($times as $time) { 
                            ?>
                            <a class="dropdown-item" href="/recipes?time=<?= $time->slug; ?>"><?= $time->name; ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <div class="col-xl-8 order-3 order-xl-4">
                <?php 
                $tags = get_terms([
                    'taxonomy' => 'recipe_tag',
                    'hide_empty' => true,
                ]); 
                if($tags) {
                    ?>
                    <div class="tag-wrapper">
                        <span>Find by tag:</span>
                        <?php foreach($tags as $tag) { ?>
                            <a href="<?= get_term_link($tag->term_id); ?>" class="tag"><?= $tag->name; ?></a>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>

        <div class="row equal-tiles">
            <?php Blue2\Scruffy\Utils::archiveLoopOffsetOne('recipe'); ?>
        </div>

        <div class="row">
            <div class="col-12 pagination">
                <?= \Blue2\Scruffy\Site::customPagination(); ?>
            </div>
        </div>
        
    </div>
</section>