<?php
if(get_sub_field('review_type')) {
    if(get_sub_field('review_type') == 'individual') {
        $type = 'reviews';
        $reviews = get_sub_field($type);
    } elseif (get_sub_field('review_type') == 'grouping') {
        $type = 'related_review_grouping'; 
        
        $args = [
            'post_type' => 'review',
            'tax_query' => [[
                'taxonomy' => 'review-grouping',
                'field' => 'term_id',
                'terms' => get_sub_field($type)
            ]],
            'posts_per_page' => -1
        ];
        $reviews = get_posts( $args );
    }
    ?>
        <section class="section section--reviews" >
            <div class="container">
                <div class="row">
                    <h1 class="accent-title">You're making us<br><span>Blu<span>sH</span></span></h1>
                    <div class="swiper-container review-swiper">
                        <div class="swiper-wrapper">
                            <?php
                            global $post;
                            foreach($reviews as $post) {
                                setup_postdata($post);
                                $imageId = get_post_thumbnail_id();
                                $image = $imageId ? wp_get_attachment_image_src($imageId, 'medium') : '';
                                $imageAlt = get_post_meta(get_post_thumbnail_id($imageId), '_wp_attachment_image_alt', true) ?: get_sub_field('title');
                                $sizeClass = $imageId ? 'col-md-7' : 'col-12 col-lg-8 align-self-center';
                                $starReview = get_field("stars") ?: "";
                                switch($starReview) {
                                    case "one":
                                        $starReview = 1; break;
                                    case "two":
                                        $starReview = 2; break;
                                    case "three":
                                        $starReview = 3; break;
                                    case "four":
                                        $starReview = 4; break;
                                    case "five":
                                        $starReview = 5; break;
                                } 
                                ?>
                                <div class="swiper-slide"> 
                                    <div class="row justify-content-md-center">
                                        <div class="<?= $sizeClass; ?> review-copy">
                                            <blockquote>
                                                <?php the_content(); ?>
                                            </blockquote>
                                            <span class="author"><?php the_title(); ?></span>
                                            <?php if(get_field('call_to_action_label') && get_field('call_to_action_url')) { ?>
                                                <a class="btn btn-graphic" href="<?php the_field('call_to_action_url'); ?>"><?php the_field('call_to_action_label'); ?></a>
                                            <?php } ?>
                                        </div>
                                        <?php if($image) { ?>
                                            <div class="col-md-5 text-center">
                                                <?php if ($starReview !== "" && $starReview !== 0) { ?>
                                                    <div class="rating">
                                                        <p><?= $starReview; ?> stars</p>
                                                    </div>
                                                <?php } ?>
                                                <img class="img-fluid" src="<?= $image[0]; ?>" alt="<?= $imageAlt; ?>" />
                                                <?php if ($starReview !== "" && $starReview !== 0) { ?>
                                                    <div class="stars-rating">
                                                        <?php
                                                            $starCount = 0;
                                                            while ($starCount < $starReview) {
                                                        ?>
                                                                <i class="fas fa-star"></i>
                                                        <?php
                                                                $starCount++;
                                                            }
                                                        ?>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <!-- Add Arrows -->
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                </div>
            </div>
        </section>
    <?php 

    wp_reset_postdata(); 
} 
