<?php
$backgroundImage = get_field('404_background_image', 'option') ? wp_get_attachment_image_src(get_field('404_background_image', 'option'), 'fullwidth') : '';
$secondaryImage = get_field('second_layer_image', 'option') ? wp_get_attachment_image_src(get_field('second_layer_image', 'option'), 'fullwidth') : '';
?>

<section <?php post_class("content-container default-top not-found-wrapper"); ?> style="background-image: url('<?= $backgroundImage[0]; ?>');">
    <div class="container">
        <div class="banner-container banner-container__404">
            <h2 class="accent">404: Page not found</h2>
            <?= get_field('page_not_found_content', 'option'); ?>
            <?= get_search_form(); ?>

            <?php
            if(have_rows('recommended_links', 'option')) {
                ?>
                <h3 class="may-suggest">May we suggest:</h3>
                <div class="row">
                    <div class="col-12">
                        <ul class="list-inline">
                            <?php
                            while(have_rows('recommended_links', 'option')) {
                                the_row();
                            ?>
                                <li><a href="<?php the_sub_field('url'); ?>"><?php the_sub_field('label'); ?></a></li>

                             <?php } ?>
                        </ul>
                    </div>
                </div>
             <?php } ?>
                   
        </div>
        <!-- <div class="secondary-image" style="background-image: url('<?= $secondaryImage[0]; ?>');"></div> -->
        <img class="img-fluid secondary-image" src="<?= $secondaryImage[0]; ?>" />
    </div>
</section>
