<?php
/**
 * Checkout login form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( is_user_logged_in() || 'no' === get_option( 'woocommerce_enable_checkout_login_reminder' ) ) {
	return;
}

$info_message  = apply_filters( 'woocommerce_checkout_login_message', __( 'If you have shopped with us before,', 'woocommerce' ) );
$info_message .= ' <a href="#" class="showlogin">' . __( 'Please login', 'woocommerce' ) . '</a>';
wc_print_notice( $info_message, 'notice' ); ?>

<form class="woocommerce-form woocommerce-form-login login" method="post" style="display: flex;">
	<h4>Returning Customer Login</h3><br/>
    <p>If you have shopped with us before, please login. If you are a new customer, please enter your details in the NEW USER CHECKOUT section below. If you cannot remember your login details please click on 'Forgotten your password?'' to reset it.  </p>

	<p class="form-row form-row-first">
		<label for="username">Username or Email <span class="required">*</span></label>
		<input type="text" class="input-text" name="username" id="username">
	</p>
	<p class="form-row form-row-last">
		<label for="password">Password <span class="required">*</span></label>
		<input class="input-text" type="password" name="password" id="password">
	</p>
	<div class="clear"></div>
	
	<p class="form-row">
		<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
		<input type="submit" class="button" name="login" value="Login">
		<input type="hidden" name="redirect" value="<?= get_site_url(); ?>/checkout/">
		<label class="woocommerce-form__label woocommerce-form__label-for-checkbox inline">
			<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever"> <span>Remember me</span>
		</label>
	</p>
	<p class="lost_password">
		<a href="<?= esc_url( wp_lostpassword_url( get_home_url() ) ); ?>">Forgotten your password?</a>
	</p>

	<div class="clear"></div>	
</form>
<?php

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */