<section class="section section-news-archive section-post-single section--white">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php
                if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                }
                ?>
            </div>
            <div class="col-lg-12">
                <h1 itemprop="headline" class="entry-title"><?php the_title(); ?></h1>
                <span class="header-time"><time class="updated" itemprop="datePublished" datetime="<?= get_post_time('c', true); ?>"><?= get_the_date(); ?></time></span>
            </div>
            <div class="col-lg-8 article-content">
                <meta itemprop="description" content="">
                <meta itemprop="author" content="Simon Howie">
                <meta itemprop="publisher" content="Simon Howie news">
                <div class="entry-content">
                    <?php
                    $authorId = get_the_author_meta('ID');
                    $avatarId = get_field('avatar_used_on_news', 'user_' . $authorId);
                    $avatar = $avatarId ? "<img class='news-avatar' src='" . wp_get_attachment_image_src($avatarId, 'award-square')[0] . "' />" : get_avatar($authorId, 50);
                    ?>
                    <span class="author-avatar"><?= $avatar; ?></span>

                    <?php 
                    if(get_field('horizontal_image')) {
                        $image = wp_get_attachment_image_src(get_field('horizontal_image'), 'news-single');
                        $alt = get_post_meta(get_field('horizontal_image'), '_wp_attachment_image_alt', TRUE);
                        echo "<img src='" . $image[0] . "' alt='" . $alt . "'/>";
                    } else if (has_post_thumbnail()) { ?>
                        <div itemprop="image">
                            <?php the_post_thumbnail('news-single'); ?>
                        </div>
                    <?php } ?>
                    <div itemprop="articleBody" class="articleBody">
                        <?php the_content(); ?>
                    </div>
                    <div class="post-navigation">
                        <?php if (get_next_post()) { ?>
                            <div class="next-posts">
                                <img class="bg-button"
                                     src="<?php echo get_template_directory_uri(); ?>/dist/images/brush-device1.svg" alt="brush stroke background" />
                                <?php next_post_link('%link', 'Next article') ?>
                            </div>
                        <?php } ?>
                        <?php if (get_previous_post()) { ?>
                            <div class="prev-posts">
                                <img class="bg-button"
                                     src="<?php echo get_template_directory_uri(); ?>/dist/images/brush-device1.svg" alt="brush stroke background" />
                                <?php previous_post_link('%link', 'Previous article') ?>
                            </div>
                        <?php } ?>

                        <?php if(get_field('subscribe_shortcode', 'option')) { ?>
                            <div class="subscribe-form-wrapper">
                                <h3><?php the_field('subscribe_title', 'option'); ?></h3>
                                <?= do_shortcode(get_field('subscribe_shortcode', 'option')); ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>


            </div>
            <div class="col-lg-4">
                <?php get_template_part('templates/post/parts/sidebar') ?>
            </div>

        </div>
    </div>
</section>

<?php Blue2\Scruffy\Utils::flexibleLoop();