<?php

$socialMedia = get_sub_field('social_media_post');

if ($socialMedia) {

	$post = $socialMedia;
	setup_postdata( $post ); 


        $img =  wp_get_attachment_image_url(get_post_thumbnail_id(), 'general-tile');
        $alt = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
        
        $singleTileImage = get_field('single_tile_image');

        $singleTileImage = $singleTileImage ? $singleTileImage['sizes']['general-tile'] : $img;
        
        $url = get_field('call_to_action_url');
        switch(get_field('social_platform')) {
            case 'facebook':
                $platform = '<a class="facebook" href="' . get_field('facebook_url', 'option') . '" target="_blank"><span class="sr-only">Facebook link</span><i class="fab fa-facebook-f"></i></a>';
                break;
            case 'instagram':
                $platform = ' <a class="instagram" href="' . get_field('instagram_url', 'option') . '" target="_blank"><span class="sr-only">Instagram link</span><i class="fab fa-instagram"></i></a>';
                break;
            case 'twitter':
                $platform = ' <a class="twitter" href="' . get_field('twitter_url', 'option') . '" target="_blank"><span class="sr-only">Twitter link</span><i class="fab fa-twitter"></i></a>';
                break;
            case 'youtube':
                $platform = '<a class="youtube" href="' . get_field('youtube_url', 'option') . '" target="_blank"><span class="sr-only">Youtube link</span><i class="fab fa-youtube"></i></a>';
                break;
        };
        ?>
        <div class="social-stream social-stream--single">
            <article>
                <div class="social-post">
                    <div class="icon">
                        <?= $platform; ?>
                    </div>
                    <a target="_blank" class="image-link" href="<?= $url; ?>" >
                        <span class="cta">View post</span>
                        <img class="img-fluid" src="<?= $singleTileImage; ?>" alt="<?= $alt; ?>" />
                    </a>
                    <?php if(!empty(get_the_content())) { ?>
                        <div class="caption">
                            <?php the_content(); ?>
                        </div>                 
                    <?php } ?>           
                </div>
            </article>
        </div>
        <?php
        
     wp_reset_postdata();
} 