<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

if ( ! $product->is_purchasable() ) {
	return;
}

echo wc_get_stock_html( $product );
$additionalClasses = "";
if(is_product()) {
	$additionalClasses .= "d-flex";

	if(get_field('quantity') == true) {
		$additionalClasses .= " cart-quantity-item";
	}
} else {
	$additionalClasses .= "form-ajax";
}

if ( $product->is_in_stock() ) : ?>

	<?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>

	<?php if(is_product()) { ?>
        <h2><?php the_field('product_sub_line'); ?></h2>
	<?php } ?>

	<form class="cart <?= $additionalClasses; ?>" data-price="<?= $product->get_price(); ?>" method="post" enctype='multipart/form-data'>
		<?php
			/**
			 * @since 2.1.0.
			 */
			do_action( 'woocommerce_before_add_to_cart_button' );

			/**
			 * @since 3.0.0.
			 */
			if(is_product() || get_field('quantity', $product->get_id()) == true) {	
				?>

				<?php if (get_field('custom_options') ?? false) {
					$num_options = get_field('custom_options_num');
					$choices = get_field('custom_options_choices');
					?>
					<div class="customOptions flex-fill">
						<?php for ($i = 0; $i < $num_options; $i++) { ?>
							<select class="customOptions__select" name="custom_options[]" aria-label="Choose an option" required>
								<option value>Choose an option</option>
								<?php foreach ($choices as $choice) { ?>
									<option value="<?= esc_attr($choice['name']); ?>"><?= esc_textarea($choice['name']); ?></option>
								<?php } ?>
							</select>
						<?php } ?>
					</div>
				<?php } ?>

				<div class="flex-fill">
					<?php
					do_action( 'woocommerce_before_add_to_cart_quantity' );

					woocommerce_quantity_input( array(
						'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
						'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
						'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( $_POST['quantity'] ) : $product->get_min_purchase_quantity(),
						'classes'	  => apply_filters( 'woocommerce_quantity_input_classes', array( 'input-text', 'qty', 'text', 'flex-fill'))
					) );

					/**
					 * @since 3.0.0.
					 */
					do_action( 'woocommerce_after_add_to_cart_quantity' );

					?>
				</div>

				<?php if(is_product() && get_field('quantity') == true) { ?>
					
					<div class="woocommerce-variation single_variation simple-product-white-price">
						<?php if(get_field('price_approx') == true) { ?>
							<span class='approx-price approx-price-variations'>Approx.</span>
						<?php } ?>
						<div class="woocommerce-variation-price">
							<span class="price">
								<?= $product->get_price_html(); ?>
							</span>
						</div>

					</div>
				<?php } ?>
		
				<?php
			}
			global $wp;
			$url = home_url($wp->request) . '?add-to-cart=' . esc_attr($product->get_id());
		?>

		<?php if(is_product()) { ?>
			<button type="submit" name="add-to-cart" data-productid="<?= $product->get_id(); ?>" value="<?= esc_attr( $product->get_id() ); ?>" class="single_add_to_cart_button button alt flex-fill"><i class="fas fa-plus"></i> <span class="wording">add to my <br/> basket</span></button>
		<?php } else { ?>
			<button type="submit" name="add-to-cart" data-productid="<?= $product->get_id(); ?>" value="<?= esc_attr( $product->get_id() ); ?>" class="single_add_to_cart_button button alt "><i class="fas fa-plus"></i><br/>add</button>
		<?php } ?>
		
		<?php
			/**
			 * @since 2.1.0.
			 */
			do_action( 'woocommerce_after_add_to_cart_button' );
		?>

		<?php if(!is_product() && get_field('quantity', $product->get_id()) == true) { ?>
			<div class="woocommerce-variation single_variation">

				<div class="woocommerce-variation-price">
					<span class="price">
						<?php if(get_field('price_approx') == true) { ?>
							<span class='approx-price'>Approx.</span>
						<?php } ?>
						<span class="woocommerce-Price-amount amount">
							<span class="woocommerce-Price-currencySymbol">£</span><?= $product->get_price(); ?>
						</span>
					</span>
				</div>
			
			</div>
		<?php } ?>
	</form>

	<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>

<?php endif; ?>
