<?php wp_footer(); ?>
<!-- Go to www.addthis.com/dashboard to customize your tools --> 
<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-5c813c98cbf2666e"></script>
<?php 
$postType =  get_post_type(); 
$postID = get_the_ID();
?>


<?php

if ($postType == "recipe") {

    $posts = get_posts(array(
        'posts_per_page'	=> -1,
        'post_type'			=> 'review',
        'meta_query'	=> array(
            'relation'		=> 'AND',
            array(
                'key'	 	=> 'is_recipe_review',
                'value'	  	=> '1',
                'compare' 	=> '=',
            ),
            array(
                'key'	  	=> 'recipe_id',
                'value'	  	=> get_the_ID(),
                'compare' 	=> '=',
            ),
        ),
    ));

    $reviews = "";
    $starRatingIntValArray = [];
    $postCount = 1;
    $totalPosts = count($posts);

    if( $posts ) { ?>
            
        <?php foreach( $posts as $post ) {
            
            setup_postdata( $post );
            $starRatingIntVal = 0;

            switch (get_field('stars',get_the_ID())) {
                case "one":
                    $starRatingIntVal = 1;
                    break;
                case "two":
                    $starRatingIntVal = 2;
                    break;
                case "three":
                    $starRatingIntVal = 3;
                    break;
                case "four":
                    $starRatingIntVal = 4;
                    break;
                case "five":
                    $starRatingIntVal = 5;
                    break;
            }

            array_push($starRatingIntValArray,$starRatingIntVal);

            $reviews .= '
            {
                "@type": "Review",
                "reviewRating": {
                    "@type": "Rating",
                    "ratingValue": "'.$starRatingIntVal.'"
                },
                "author": {
                    "@type": "Person",
                    "name": "'.get_the_title().'"
                },
                "datePublished": "'. get_the_date() .'",
                "reviewBody": "'.get_the_content().'"
            }';

            if ($totalPosts !== $postCount) {
                $reviews .= ',';
            }
            $postCount++;
        }
        wp_reset_postdata();
        wp_reset_query();

        if ($reviews !== "") {
            $reviewsString = '
            "review": ['.$reviews.'],';
        } else {
            $reviewsString = "";
        }

        $averageRating = 0;
        foreach($starRatingIntValArray as $starRating) {
            $averageRating = $averageRating + $starRating;
        }

        $averageRating = $averageRating / count($starRatingIntValArray);

        $aggregateReviewString = '
        "aggregateRating": {
            "@type": "AggregateRating",
            "ratingValue": "'.$averageRating.'",
            "bestRating": "5",
            "ratingCount": "'.count($starRatingIntValArray).'"
        }';

        $ingredientsList = "";
        if (get_field('ingredients',$postID)) { 
            $ingredients = get_field('ingredients',$postID);
            $ingredients = explode("\n", get_field('ingredients',$postID));
            
            $recipeCount = 2;
            $totalRecipes = count($ingredients);
            foreach ($ingredients as $ingredient) {
                if ($ingredient != '') {
                    $ingredientsList .= '"' . strip_tags($ingredient) . '"';
                    if ($totalRecipes !== $recipeCount) {
                        $ingredientsList .= ',';
                    }
                    $recipeCount++;
                }
            }
        }

        $recipeImageId = get_post_thumbnail_id();
        $recipeImage = $recipeImageId ? wp_get_attachment_image_src($recipeImageId, 'general-tile') : "";
        $recipeImageSrc = "";

        if ($recipeImage) {
            $recipeImageSrc = $recipeImage[0];
        }

        $prepTime = get_field('time_to_prepare',$postID) ?? "";
        $cookingTime = get_field('cooking_time',$postID) ?? "";
        if ($prepTime !== "" && $cookingTime !== "") {
            $totalTime = strval(intval($prepTime) + intval($cookingTime));
        } else {
            $totalTime = "";
        }
        $servesPeople = get_field('serves',$postID) ?? "";

        echo '
        <script type="application/ld+json">
        {
        "@context": "https://schema.org/",
        "@type": "Recipe",
        "name": "'.get_the_title().'",
        "image": [
            "'.$recipeImageSrc.'"
        ],
        "author": {
            "@type": "Person",
            "name": "'.get_the_author_meta('display_name').'"
        },
        "datePublished": "'.get_the_date().'",
        "description": "'.get_the_excerpt().'",
        "prepTime": "'.$prepTime.'",
        "cookTime": "'.$cookingTime.'",
        "totalTime": "'.$totalTime.' mins",
        "recipeYield": "'.$servesPeople.'",
        "recipeIngredient": ['.$ingredientsList.'],'.
        $reviewsString .
        $aggregateReviewString
        .'
        }
        </script>';
    } 

}
?>

</body>
</html>
