<?php

namespace Blue2\Scruffy\Controllers;

use B2\Order\OrderPackSize;
use B2\OrderController;

class WoocommerceController
{
    public function __construct()
    {
        // Remove actions
        remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
        remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
        remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
        remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
        remove_action('woocommerce_thankyou', 'woocommerce_order_details_table', 10);

        // Add actions
        add_action('woocommerce_product_query', [$this, 'customPreGetPostsQuery']);
        add_action('wp_enqueue_scripts', [$this, 'enqueueScripts']);
        // add_action('wp_footer', [$this, 'addQuanityJs'], 10);
        add_action('init', [$this, 'loadAjaxCheckout']);
        add_action('woocommerce_after_single_product_summary', [$this, 'afterSingleSummary'], 20);

        add_action('wp_ajax_getAjaxPosts', [$this, 'getAjaxPosts']);
        add_action('wp_ajax_nopriv_getAjaxPosts', [$this, 'getAjaxPosts']);

        add_action('wp_ajax_loadMorePosts', [$this, 'loadMorePosts']);
        add_action('wp_ajax_nopriv_loadMorePosts', [$this, 'loadMorePosts']);
        add_action('woocommerce_init', [$this, 'removeProductSchemaOnArchive']);
        add_action('woocommerce_thankyou', [$this, 'b2ViewOrder'], 10);


        // Add filters loadMorePosts
        add_filter('woocommerce_is_checkout', [$this, 'changePagesToCheckout']);
        add_filter('woocommerce_add_to_cart_redirect', [$this, 'redirectProductSingleAddToCart']);
        add_filter('wc_add_to_cart_message_html', '__return_false');
        // add_filter ('woocommerce_checkout_cart_item_quantity', 'remove_quantity_text', 10, 2 );
        add_filter('woocommerce_cart_item_name', [$this, 'addQuantity'], 10, 3);
        add_filter('woocommerce_breadcrumb_defaults', [$this, 'changeWoocommerceBreadcrumbs']);
        // add_filter('woocommerce_get_price_html', [$this, 'customPriceMessage']);
        // add_filter( 'woocommerce_variable_price_html',  [$this, 'customPriceMessage']);

        add_filter('woocommerce_add_to_cart_fragments', [$this, 'cartCountFragments'], 10, 1);
        add_filter('woocommerce_get_catalog_ordering_args', [$this, 'productsOrderBy']);
        add_filter('woocommerce_show_variation_price', [$this, 'alwaysShowPrice'], 99, 3);
        add_filter('wpseo_breadcrumb_links', [$this, 'productBreadcrumbAppend']);
        add_filter('woocommerce_order_item_class', [$this, 'extraClassesToOrderItem'], 99, 3);

        // Add theme support
        add_theme_support('woocommerce');

        add_action('woocommerce_before_main_content', [$this, 'customOpenDiv'], 5);
        add_action('woocommerce_after_main_content', [$this, 'customCloseDiv'], 50);

        add_action('woocommerce_checkout_order_processed', [$this, 'sendFactoryEmail'], 10, 3);
        add_filter('woocommerce_email_subject_new_order', [$this, 'changeNewOrderEmailSubject'], 10, 2);
        add_filter('gettext', [$this, 'changeBillingDetailsText'], 20, 3);
        
        add_action('wp_ajax_sh_set_delivery_date', [ $this, 'setDeliveryDate' ]);
        add_action('wp_ajax_nopriv_sh_set_delivery_date', [ $this, 'setDeliveryDate' ]);

        add_action('wp_ajax_sh_set_delivery_postcode', [ $this, 'setDeliveryPostcode' ]);
        add_action('wp_ajax_nopriv_sh_set_delivery_postcode', [ $this, 'setDeliveryPostcode' ]);

        add_filter('wpseo_metadesc', [$this, 'getImagePreview']);

        
        // add pickup location information and a pickup appointment field to each package meant for pickup
        add_action('woocommerce_after_shipping_rate', [ $this, 'outputDeliveryDateField' ], 999, 2);
        add_filter('woocommerce_package_rates', [$this, 'calculateFreePostage'], 999, 2);
        add_action('woocommerce_after_checkout_validation', [$this, 'validateDeliveryDate'], 10, 2);
        add_action('woocommerce_checkout_order_processed', [$this, 'saveDeliveryDate'], 10, 3);
        add_filter('woocommerce_payment_gateways', [$this, 'addPayByPhone']);
        add_filter('wc_local_pickup_plus_cart_shipping_packages', [$this, 'combinePackages']);
        add_filter('woocommerce_available_payment_gateways', [$this, 'allowAllPaymentTypes']);

        //Fix for initial swap to delivery
        if (function_exists('wc_local_pickup_plus')) {
            $pickup = wc_local_pickup_plus();
            $ajax = $pickup->get_ajax_instance();
            remove_action('wp_ajax_wc_local_pickup_plus_set_default_handling', [ $ajax, 'set_default_handling' ]);
            remove_action('wp_ajax_nopriv_wc_local_pickup_plus_set_default_handling', [ $ajax, 'set_default_handling' ]);
            add_action('wp_ajax_wc_local_pickup_plus_set_default_handling', [ $this, 'set_default_handling' ]);
            add_action('wp_ajax_nopriv_wc_local_pickup_plus_set_default_handling', [ $this, 'set_default_handling' ]);
        }

        // custom options
        add_action('woocommerce_add_cart_item_data', [$this, 'custom_options_handle'], 10, 1);
        add_filter('woocommerce_get_item_data', [$this, 'custom_options_item_data'], 10, 2);
        add_action('woocommerce_checkout_create_order_line_item', [$this, 'custom_options_add_meta'], 10, 1);

        //add custom login messages on the login forms
        add_filter('login_errors', [$this, 'login_error_message']);

        add_filter( 'woocommerce_calculated_total', [$this, 'custom_calculated_total'], 10, 2 );
    }

    function custom_calculated_total( $total, $cart ){

        $basketTotal = WC()->cart->cart_contents_total;
        $basketTotalInt = intval($basketTotal);
        foreach( WC()->session->get('shipping_for_package_0')['rates'] as $method_id => $rate ){
            if( WC()->session->get('chosen_shipping_methods')[0] == $method_id ){
                if ($method_id == "flat_rate:4") {
                    if ($basketTotal >= 50) {
                        return $basketTotal;
                    } else {
                        return $basketTotal + 3.99;
                    }
                }
            }
        }
        return $basketTotal;
    }

    public function allowAllPaymentTypes($availableGateways)
    {
        global $wp_query;
        //workaround for process_checkout issue.
        return $wp_query->get('wc-ajax') == 'checkout' ? \WC_Payment_Gateways::instance()->payment_gateways() : $availableGateways;
    }

    public function combinePackages($packages)
    {
        $deliveryType = WC()->session->get('wc_local_pickup_plus_default_handling', false);
        $allProducts = array_merge($packages['pickup_items'], $packages['ship_items']);
        
        if ($deliveryType == 'ship') {
            $packages = [
                'pickup_items' => [],
                'ship_items'   => $allProducts,
            ];
        } else {
            $packages = [
                'ship_items' => [],
                'pickup_items'   => $allProducts,
            ];
        }

        return $packages;
    }

    public function set_default_handling()
    {
        $handling      = ! empty($_POST['handling']) && in_array($_POST['handling'], array( 'pickup', 'ship' ), true) ? $_POST['handling'] : wc_local_pickup_plus_shipping_method()->get_default_handling();
        $cart_contents = WC()->cart->cart_contents;
        $cart_items    = WC()->session->get('wc_local_pickup_plus_cart_items', array());
        $new_items     = array();

        $set_for_shipping = array(
            'handling'           => 'ship',
            'lookup_area'        => '',
            'pickup_location_id' => 0,
        );

        $set_for_pickup   = array(
            'handling'    => 'pickup',
            'lookup_area' => '',
        );

        foreach ($cart_items as $cart_item_id => $cart_item_data) {
            if (isset($cart_contents[ $cart_item_id ], $cart_contents[ $cart_item_id ]['data']) && $cart_contents[ $cart_item_id ]['data'] instanceof WC_Product) {
                if ('pickup' === $handling && wc_local_pickup_plus_product_can_be_picked_up($cart_contents[ $cart_item_id ]['data'])) {
                    $new_items[ $cart_item_id ] = $set_for_pickup;
                } elseif ('ship' === $handling) {
                    if (wc_local_pickup_plus_product_must_be_picked_up($cart_contents[ $cart_item_id ]['data'])) {
                        $new_items[ $cart_item_id ] = $set_for_pickup;
                    } else {
                        $new_items[ $cart_item_id ] = $set_for_shipping;
                    }
                }
            }
        }

        // merge new handling data with existing - this ensures that pickup locations are not overriden for
        // pickup-only items
        foreach ($new_items as $cart_item_key => $data) {
            wc_local_pickup_plus()->get_session_instance()->set_cart_item_pickup_data($cart_item_key, $data);
        }

        WC()->session->set('wc_local_pickup_plus_packages', array());
        WC()->session->set('wc_local_pickup_plus_default_handling', $handling);

        wp_send_json_success($handling);
    }

    public function addPayByPhone($gateways)
    {
        require_once('WC_Gateway_PBP.php');
        $gateways[] = 'WC_Gateway_PBP';
        
        return $gateways;
    }

    public function validateDeliveryDate($data, &$errors)
    {
        $deliveryType = isset($_POST['deliveryType']) ? wc_clean($_POST['deliveryType']) : '';
        $deliveryDatePost = isset($_POST['deliveryDate']) ? wc_clean($_POST['deliveryDate']) : '';

        if ($deliveryType != 'pickup') {
            $userPostcode = strtolower($data['billing_postcode']);
            $userPostcode = str_replace(' ', '', $userPostcode);

            $postcodeDeliveryDates = get_field('postcode_delivery_dates', 'option');

            $postcodeValidated = false;
            $availableDays = [];

            foreach ($postcodeDeliveryDates as $postcodeDeliveryDate) {
                $postcodeString = strtolower($postcodeDeliveryDate['postcodes']);
                $postcodeString = str_replace(' ', '', $postcodeString);
                
                $acceptedPostcodes = explode(',', $postcodeString);

                if (in_array($userPostcode, $acceptedPostcodes)) {
                    $postcodeValidated = true;
                    $availableDays = $postcodeDeliveryDate['available_delivery_dates_by_day'];
                    break;
                }
            }

            if (!$postcodeValidated) {
                $errors->add('validation', sprintf(__('%s is not a valid delivery postcode', 'woocommerce'), '<strong>' . esc_html($data['billing_postcode']) . '</strong>'));
                return;
            }

            $deliveryDate = new \DateTime($deliveryDatePost);
            $day = $deliveryDate->format('w');

            if (!in_array($day, $availableDays)) {
                $errors->add('validation', sprintf(__('%s is not a valid delivery date for this postcode, please select another date', 'woocommerce'), '<strong>' . esc_html($deliveryDatePost) . '</strong>'));
                return;
            }

            //check lead time
            $firstAvailable = $this->getFirstAvailableDate();
            $firstAvailable->setTime(00, 00);
            if ($deliveryDate<$firstAvailable) {
                $errors->add('validation', sprintf(__('%s is not available for delivery, please select another date', 'woocommerce'), '<strong>' . esc_html($deliveryDatePost) . '</strong>'));
                return;
            }
        }
    }

    private function getFirstAvailableDate()
    {
        $leadTime = get_field('delivery_lead_time', 'option');
        if (!$leadTime) {
            $leadTime = 1;
        }
        $firstAvailable = new \DateTime('+ '. $leadTime .' hours', new \DateTimeZone('Europe/London'));

        //if current time is outside business hours, move into next day
        $endOfDay = clone $firstAvailable;
        $endOfDay->setTime(17, 00);

        if ($firstAvailable>=$endOfDay) {
            $firstAvailable->add(new \DateInterval('P1D'));
        }

        return $firstAvailable;
    }

    public function saveDeliveryDate($order_id, $posted_data, &$order)
    {
        $deliveryType = isset($_POST['deliveryType']) ? wc_clean($_POST['deliveryType']) : '';
        $deliveryDatePost = isset($_POST['deliveryDate']) ? wc_clean($_POST['deliveryDate']) : '';
        $deliveryDate = new \DateTime($deliveryDatePost);
        $userPostcode = strtolower($posted_data['billing_postcode']);

        update_post_meta($order_id, 'deliveryType', $deliveryType);
        
        WC()->session->set('sh_delivery_postcode', null);
        WC()->session->set('sh_delivery_date', null);

        if ($deliveryType != 'pickup') {
            update_post_meta($order_id, 'deliveryDate', $deliveryDatePost);
            $postcodeDeliveryDates = get_field('postcode_delivery_dates', 'option');

            //Add to location
            $userPostcode = str_replace(' ', '', $userPostcode);
            $location = null;
            foreach ($postcodeDeliveryDates as $postcodeDeliveryDate) {
                $postcodeString = strtolower($postcodeDeliveryDate['postcodes']);
                $postcodeString = str_replace(' ', '', $postcodeString);
                $acceptedPostcodes = explode(',', $postcodeString);

                if (in_array($userPostcode, $acceptedPostcodes)) {
                    $location = $postcodeDeliveryDate['delivery_source_store'][0];
                }
            }
            if ($location) {
                foreach ($order->get_items('shipping') as $itemId => $shippingObject) {
                    $shippingObject->add_meta_data('_pickup_location_name', $location->post_title, true);
                    $shippingObject->add_meta_data('_pickup_location_id', $location->ID, true);
                    $shippingObject->add_meta_data('_pickup_date', $deliveryDate->format('Y-m-d'), true);
                    $shippingObject->save_meta_data();
                }
            }
        }
    }

    public function calculateFreePostage($rates, $packages = array())
    {
        $cartTotal = WC()->cart->get_subtotal();
        $freeDeliveryThreshold = get_field('free_delivery_threshold', 'option');

        if ($cartTotal >= $freeDeliveryThreshold) {
            foreach ($rates as &$rate) {
                if ($rate->get_method_id() == 'flat_rate') {
                    $rate->set_cost(0);
                    $rate->set_label('Free Delivery');
                }
            }
        }

        //override to deal with new customer issue
        if (isset($_POST['deliveryType']) && $_POST['deliveryType'] == 'ship') {
            if ($cartTotal >= $freeDeliveryThreshold) {
                foreach ($rates as &$rate) {
                    $rate->set_cost(0);
                    $rate->set_label('Free Delivery');
                }
            } else {
                foreach ($rates as &$rate) {
                    $methods = WC()->shipping->get_shipping_methods();
                    $rate->set_cost($methods[4]->cost);
                    $rate->set_label($methods[4]->title);
                }
            }
        }
        return $rates;
    }

    public function changeBillingDetailsText($translatedText, $text, $domain)
    {
        switch ($translatedText) {
            case 'Billing details':
                if ( is_user_logged_in() ) {
                    $translatedText = __('Your Details', 'woocommerce');
                    break;
                }
                else {
                    $translatedText = __('New User Checkout', 'woocommerce');
                    break;
                }
        }
        return $translatedText;
    }

    public static function getAjaxPosts()
    {
        $postsPerPage = 21;
        isset($_POST['category']) ? $category = $_POST['category'] : $category = 'click-collect';
        isset($_POST['tag']) && $_POST['tag'] != '' ? $tag = ['taxonomy' => 'product_tag', 'field' => 'slug', 'terms' => [$_POST['tag']], 'operator' => 'IN'] : $tag = '';

        $args = [
            'post_type' => ['product'],
            'post_status' => ['publish'],
            'posts_per_page' => $postsPerPage,
            'orderby' => [
                'meta_value_num' => 'asc',
                'title' => 'asc',
            ],
            'order' => 'asc',
            'meta_key' => 'sorting_order',
            'tax_query' => [
                [
                    'taxonomy' => 'product_cat',
                    'field' => 'slug',
                    'terms' => [$category],
                    'operator' => 'IN',
                ],
                $tag,
            ],
            's' => $_POST['search'],
        ];

        $products = new \WP_Query($args);

        if ($products->have_posts()) {
            while ($products->have_posts()) {
                $products->the_post();
                do_action('woocommerce_shop_loop');
                wc_get_template_part('content', 'product');
            }
        } else {
            echo '<p class="end">You have reached the end of the product list.</p>';
        }
        wp_die();
    }

    public static function loadMorePosts()
    {
        $postsPerPage = 15;
        $offset = ($_POST['pageNumber'] * $postsPerPage) + 1;
        if ( get_option('products') ) {
            $products = get_option( 'products');
        }

        isset($_POST['category']) ? $category = $_POST['category'] : $category = 'click-collect';
        isset($_POST['tag']) && $_POST['tag'] != '' ? $tag = ['taxonomy' => 'product_tag', 'field' => 'slug', 'terms' => [$_POST['tag']], 'operator' => 'IN'] : $tag = '';

        $product_ids = explode(',', $products);

        $args = [
            'post_type' => ['product'],
            'post_status' => ['publish'],
            'posts_per_page' => $postsPerPage,
            'offset' => $offset,
            'meta_key' => 'sorting_order',
            'orderby' => [
                'meta_value_num' => 'asc',
                'title' => 'asc',
            ],
            'tax_query' => [
                [
                    'taxonomy' => 'product_cat',
                    'field' => 'slug',
                    'terms' => [$category],
                    'operator' => 'IN',
                ],
                $tag,
            ],
            's' => $_POST['search'],
        ];

        $products = new \WP_Query($args);

        if ($products->have_posts()) {
            while ($products->have_posts()) {
                $products->the_post();
                if (!in_array(get_the_ID(), $product_ids)) {
                    do_action('woocommerce_shop_loop');
                    wc_get_template_part('content', 'product');
                    $product_ids[] = get_the_ID();
                }
            }

            update_option( 'products', implode(',', $product_ids));
        } else {
            echo '<p class="end">You have reached the end of the product list.</p>';
        }
        wp_die();
    }

    public static function checkProductLocation($availableLocations)
    {
        $additionalClasses = "";
        if ($availableLocations) {
            $productSession = wc_local_pickup_plus()->get_session_instance()->get_package_pickup_data();
            $selectedLocation = $productSession ? $productSession['package_0']['pickup_location_id'] : '';
            if ($selectedLocation) {
                foreach ($availableLocations as $location) {
                    $additionalClasses = $location == $selectedLocation ? 'available' : 'not-available';
                    if ($additionalClasses == 'available') {
                        break;
                    }
                }
            }
        } else {
            $additionalClasses = 'not-available';
        }

        return $additionalClasses;
    }

    public static function checkProductAvailability($productId)
    {
        /** Check for categories with date for availability */
        $categories = wp_get_post_terms($productId, 'product_cat');
        // $now = current_time('d/m/Y');
        $additionalClasses = "";

        foreach ($categories as $category) {
            if (get_field('limited_availability', $category) == true) {
                $collectionFrom = get_field('allow_collection_from', $category);
                $collectionUntil = get_field('allow_collection_until', $category);
                break;
            }
        }

        if (isset($collectionFrom) && isset($collectionUntil)) {
            $productSession = wc_local_pickup_plus()->get_session_instance()->get_package_pickup_data();
            $pickupDate = $productSession['package_0']['pickup_date'];
            $pickupDate = date('d/m/Y', strtotime($pickupDate));

            if (!($pickupDate >= $collectionFrom && $pickupDate < $collectionUntil)) {
                $dateContent = "Can be collected only between " . $collectionFrom . " and " . $collectionUntil;
                $additionalClasses = "not-available"; ?>
                <style>
                    .shop_table tr.not-available.postId-<?= $productId; ?>:before {
                        content: "<?= $dateContent; ?>" !important;
                    }

                    ;
                </style>
                <?php
            }
        }

        return $additionalClasses;
    }

    public static function addOverlayText($productId, $availableLocation, $type = "cart")
    {
        if ($availableLocation === 285) {
            $content = "Currently only available in Auchterarder";
        } elseif ($availableLocation === 286) {
            $content = "Currently only available in Perth";
        } else {
            $content = "Currently not available";
        }

        if ($type === "product") {
            ?>
            <style>
                .click-collect-products ul.products li.post-<?= $productId; ?>:before {
                    content: "<?= $content; ?>" !important;
                }

                ;
            </style>
        <?php
        } elseif ($type === "cart-page") { ?>
            <style>
                .shop_table tr.not-available.postId-<?= $productId; ?>:after {
                    content: "<?= $content; ?>" !important;
                }

                ;
            </style>
        <?php } else { ?>
            <style>
                .shop_table tr.not-available.postId-<?= $productId; ?>:before {
                    content: "<?= $content; ?>" !important;
                }

                ;
            </style>
        <?php } ?>
        <?php
    }


    /**
     * Remove the generated product schema markup from Product Category and Shop pages.
     */
    public function removeProductSchemaOnArchive()
    {
        remove_action('woocommerce_shop_loop', [WC()->structured_data, 'generate_product_data'], 10, 0);
    }

    public static function b2ViewOrder($order)
    {
        include(locate_template('/src/Views/b2-view-order-details.php'));
    }

    /* Add js at the footer. It is being called directly as unique name handler is required */

    public function extraClassesToOrderItem($class, $item, $order)
    {
        $attributes = $item->get_product()->get_attributes();
        $keys = array_keys($attributes);

        return $class . ' ' . implode(' ', $keys);
    }

    public function changeNewOrderEmailSubject($subject, $order)
    {
        global $woocommerce;
        $blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
        $shipping = $this->getShippingDetails($order);

        if ($this->getOrderType($order) == 'ship') {
            $subject = sprintf('[%s - ' . $shipping['Pickup Location'] . ' DELIVERY] New Customer Order (# %s) from Name %s %s', $blogname, $order->id, $order->billing_first_name, $order->billing_last_name);
        } else {
            $subject = sprintf('[%s - ' . $shipping['Pickup Location'] . '] New Customer Order (# %s) from Name %s %s', $blogname, $order->id, $order->billing_first_name, $order->billing_last_name);
        }

        return $subject;
    }

    public static function getDeliveryDetails($order)
    {
        $deliveryData = [
            'Pickup Location' => 'Delivery',
            'Delivery Date' => $order->get_meta('deliveryDate')];
        return $deliveryData;
    }

    public static function getOrderType($order)
    {
        return $order->get_meta('deliveryType');
    }

    public static function getShippingDetails($order)
    {
        $shippingDataArray = [];
        foreach ($order->get_items('shipping') as $itemId => $shippingObject) {
            $shippingData = $shippingObject->get_data();
            foreach ($shippingData['meta_data'] as $singleShippingData) {
                $singleShippingData = $singleShippingData->get_data();
                switch ($singleShippingData['key']) {
                    case '_pickup_location_name':
                        $shippingDataArray['Pickup Location'] = $singleShippingData['value'];
                        break;
                    case '_pickup_date':
                        $shippingDataArray['Pickup Date'] = $singleShippingData['value'];
                        break;
                    case '_pickup_location_address':
                        $shippingDataArray['Pickup address'] = $singleShippingData['value'];
                        break;
                }
            }
        }
        return $shippingDataArray;
    }

    public function productBreadcrumbAppend($urls)
    {
        global $post;

        if (is_product()) {
            $breadcrumb[] = [
                'url' => home_url('/click-and-collect/'),
                'text' => 'Click & Collect',
            ];
            array_splice($urls, 1, -2, $breadcrumb);
        }
        return $urls;
    }

    public function customOpenDiv()
    {
        $category = $this->checkRelatedCategory();
        if ($category == 'click-collect' && is_product()) {
            echo '<div class="click-collect-single">';
        } elseif ($category == 'supermarket' && is_product()) {
            echo '<div class="supermarket-single">';
        }
    }

    public static function checkRelatedCategory()
    {
        $termParent = isset(get_queried_object()->parent) ? get_term(get_queried_object()->parent) : '';

        if (is_product_category('click-collect') || (has_term('click-collect', 'product_cat') && is_product()) ||
            (!is_wp_error($termParent) && isset($termParent->slug) && $termParent->slug == 'click-collect') || is_shop() || is_product_tag()) {
            $category = "click-collect";
        } elseif (is_product_category('supermarket') || (has_term('supermarket', 'product_cat') && is_product()) ||
            (!is_wp_error($termParent) && isset($termParent->slug) && $termParent->slug == 'supermarket')) {
            $category = "supermarket";
        } else {
            $category = "other";
        }

        return $category;
    }

    public function customCloseDiv()
    {
        if (is_product()) {
            echo '</div>';
        }
    }

    /** Load ajax for checkout cart */
    public function loadAjaxCheckout()
    {
        if (is_checkout()) {
            if (!is_user_logged_in()) {
                add_action('wp_ajax_nopriv_update_order_review', [$this, 'update_order_review']);
            } else {
                add_action('wp_ajax_update_order_review', [$this, 'update_order_review']);
            }
        }
    }

    /** Update order on quantity change */
    public function update_order_review()
    {
        $values = [];
        parse_str($_POST['post_data'], $values);
        $cart = $values['cart'];
        foreach ($cart as $cart_key => $cart_value) {
            WC()->cart->set_quantity($cart_key, $cart_value['qty'], false);
            WC()->cart->calculate_totals();
            woocommerce_cart_totals();
        }

        wp_die();
    }

    /** Add quantity selector to checkout pages */
    public function addQuantity($product_title, $cart_item, $cart_item_key)
    {
        /* Checkout page check */
        if (is_checkout()) {
            /* Get Cart of the user */
            $cart = WC()->cart->get_cart();
            foreach ($cart as $cart_key => $cart_value) {
                if ($cart_key == $cart_item_key) {
                    $product_id = $cart_item['product_id'];
                    $_product = $cart_item['data'];

                    /* Add product name */
                    $return_value = '<span class = "product_name" >' . $product_title . '</span></a>';

                    /* Add quantity selector */
                    if (!is_cart()) {
                        if ($_product->is_sold_individually()) {
                            $return_value .= sprintf('1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_key);
                        } else {
                            $return_value .= woocommerce_quantity_input([
                                'input_name' => "cart[{$cart_key}][qty]",
                                'input_value' => $cart_item['quantity'],
                                'max_value' => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
                                'min_value' => '1',
                            ], $_product, false);
                        }
                    }
                    return $return_value;
                }
            }
        }
    }

    /**
     * Change woocommerce pages to return true for is_checkout - so that the pickup plugin works
     */
    public function changePagesToCheckout()
    {
        // if(is_shop() || is_product_category() || is_product_tag()) {
        return true;
        // }
    }

    public function afterSingleSummary()
    {
        echo "<div class='clear'></div>";
    }

    //Add in text after price to certain products

    /** Change several of the breadcrumb defaults */
    public function changeWoocommerceBreadcrumbs()
    {
        return [
            'wrap_before' => '<div class="container woocommerce_breadcrumbs">',
            'wrap_after' => '</div>',
            'delimiter' => ' &#47; ',
            'before' => '',
            'after' => '',
            'home' => _x('Home', 'breadcrumb', 'woocommerce'),
        ];
    }

    /**
     * Include only products from a click and collect category on the shop page
     */
    public function customPreGetPostsQuery($q)
    {
        $tax_query = (array)$q->get('tax_query');

        $category = $this->checkRelatedCategory();
        if ($category == 'click-collect') {
            $tax_query[] = [
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => ['click-collect'],
                'operator' => 'IN',
            ];

            $q->set('tax_query', $tax_query);
        }
    }

    /**
     * Enqueue relevant scripts to relevant pages
     */
    public function enqueueScripts()
    {
        if (is_woocommerce()) {
            $version = wc_measurement_price_calculator()->get_version();
            wp_register_script('jquery-tiptip', WC()->plugin_url() . '/assets/js/jquery-tiptip/jquery.tipTip.min.js', ['jquery'], defined('WC_VERSION') ? WC_VERSION : $version, true);
            wp_enqueue_script('wc-price-calculator', wc_measurement_price_calculator()->get_plugin_url() . '/assets/js/frontend/wc-measurement-price-calculator.min.js', ['jquery', 'jquery-cookie', 'jquery-tiptip'], $version);
        }
    }

    /**
     * Redirect single product "add to buy" button action to the shop page
     */
    public function redirectProductSingleAddToCart($url)
    {
        $shopId = get_option('woocommerce_shop_page_id');
        $url = get_permalink($shopId);

        return $url;
    }

    public function customPriceMessage($price)
    {
        global $product;
        if (get_field('price_approx') == true) {
            $price .= "<span class='approx-price'>Approx.</span>";
        }
        // if (($product->is_type('simple') || $product->is_type('variable')) && get_field('quantity', $product->get_id()) == true) {
        //     $price = get_field('price_per_kg') ? '<span class="woocommerce-Price-amount amount">' . get_field('price_per_kg') . '</span>' : $price;
        // }

        return $price;
    }

    public function productsOrderBy($sortBy)
    {
        $sortBy['orderby'] = [
                'meta_value_num' => 'asc',
                'title' => 'asc'
        ];
        $sortBy['meta_key'] = 'sorting_order';
        $sortBy['order'] = 'asc';

        return $sortBy;
    }

    public function alwaysShowPrice($show, $parent, $variation)
    {
        return true;
    }

    public function cartCountFragments($fragments)
    {
        $count = WC()->cart->get_cart_contents_count();
        if ($count > 0) {
            $fragments['div.cart-contents-wrapper'] = '<div class="cart-contents-wrapper"><span class="cart-contents-count">' . WC()->cart->get_cart_contents_count() . '</span></div>';
        } else {
            $fragments['div.cart-contents-wrapper'] = '<div class="cart-contents-wrapper"></div>';
        }
        return $fragments;
    }

    public function sendFactoryEmail($orderId)
    {
        $factoryAlert = false;
        $order = wc_get_order($orderId);

        $shipping = OrderController::getShippingDetails($order)['Pickup Location'];

        $factoryEmail = "acowan@blue2.co.uk";
        $date = strtotime($shipping['Pickup Date']);

        $body = '
            <div style="background-color:#f7f7f7;text-align:left;">
            <div style="width:896px;margin:0 auto;">
            <img src="https://s3-eu-west-1.amazonaws.com/blue2digital/pex/simonhowie/2019/05/02152443/SimonHowie-logo-on-white.png" style="text-align:center;display:block;width:300px;padding:15px;height:auto;margin:15px auto;" alt="Simon Howie Logo">        
            <div style="max-width:896px;background-color:#ea7600;color:#fff;font-size:28px;text-align:left;padding:10px 0 10px 40px;">Items Needed</div>
            <div style="background-color:#fff; padding:50px; text-align:left;">
        ';
        $body .= '<p style="color:#636363;">A new order has been received with items needed from the factory, please see all items in bold in the table below.</p>';
        $body .= '<p style="color:#636363;">This order is for <strong style="color:#ea7600;">' . date('l jS \of F Y', $date) . '.</strong></p>';
        $body .= '<p style="color:#636363;">This order should be sent to: <strong style="color:#ea7600;">' . $shipping . '</strong></p>';
        $body .= '<table cellspacing="0" cellpadding="6" style="width: 100%; font-size: 13px;">';
        $body .= '<tr style="font-weight:bold;border-bottom:1px solid #000;"><td style="padding:10px;border:1px solid #eee;">Order Item</td><td style="padding:10px;border:1px solid #eee;">Pack</td><td style="padding:10px;border:1px solid #eee;">Qty</td></tr>';

        foreach ($order->get_items() as $item_id => $item) {
            $productId = $item->get_product_id();

            $product = $item->get_product();
            $packSize = 'N/A';
            if ($product->is_type('variation')) {
                $packSize = '';
                $variation_attributes = $product->get_variation_attributes();
                foreach ($variation_attributes as $attribute_taxonomy => $term_slug) {
                    $packSize .= '<span class="pack-option">' . $term_slug . '</span> ';
                }
            }

            if (get_field('alert_factory', $productId)) {
                $factoryAlert = true;
                $body .= '<tr><td style="padding:10px;border:1px solid #eee;">' . $item->get_name() . '</td><td style="padding:10px;border:1px solid #eee;">' . $packSize . '</td><td style="padding:10px;border:1px solid #eee;">' . $item->get_quantity() . '</td></tr>';
            } else {
                $body .= '<tr><td style="padding:10px;border:1px solid #eee;">' . $item->get_name() . '</td><td style="padding:10px;border:1px solid #eee;">' . $item->get_quantity() . '</td></tr>';
            }
        }

        $body .= '</table>';
        $body .= '</div>';
        $body .= '</div>';
        $body .= '</div>';
        $body .= '</div>';
        $headers = ['Content-Type: text/html; charset=UTF-8'];

        if ($factoryAlert) {
            wp_mail(
                $factoryEmail,
                'New items needed for order',
                $body,
                $headers
            );
        }
    }

    public function getImagePreview($args)
    {
        $required = false;
        if ($_SERVER['REQUEST_URI'] == '/click-and-collect/') {
            $imageId = get_field('click_&_collect_facebook_image', 'option');
            $required = true;
        } elseif (is_post_type_archive('person')) {
            $imageId = get_field('people_facebook_image', 'option');
            $required = true;
        } elseif (is_post_type_archive('recipe') || is_tax('recipe_tag')) {
            $imageId = get_field('recipe_facebook_image', 'option');
            $required = true;
        } elseif (is_post_type_archive('vacancy')) {
            $imageId = get_field('vacancy_facebook_image', 'option');
            $required = true;
        }

        if ($required === true) {
            $imageUrl = wp_get_attachment_image_src($imageId, 'fullwidth');
            echo '<meta property="og:image" content="' . $imageUrl[0] . '" />
<meta property="og:image:secure_url" content="' . $imageUrl[0] . '" />
<meta property="og:image:width" content="' . $imageUrl[1] . '" />
<meta property="og:image:height" content="' . $imageUrl[2] . '" />';
        }
        return $args;
    }

    public function outputDeliveryDateField()
    {
        $deliveryType = WC()->session->get('wc_local_pickup_plus_default_handling', false);
        if ($deliveryType == 'ship') {
            $deliveryDate = WC()->session->get('sh_delivery_date', '');
            $deliveryPostcode = WC()->session->get('sh_delivery_postcode', '');
            $postcodeDeliveryDates = get_field('postcode_delivery_dates', 'option');
            $jsonPostcodeData = json_encode($postcodeDeliveryDates);
            
            $firstAvailable = $this->getFirstAvailableDate();

            $excludedDates = get_field('excluded_delivery_dates', 'option');
            $jsonExcludeDates = json_encode($excludedDates); ?>
            <tr class="shipping delivery_postcode">
                <th>Delivery Postcode</th>
                <td data-title="">
                    <input type="text" id="deliveryPostcode" name="deliveryPostcode" value ="<?= $deliveryPostcode ?>" placeholder="Enter your postcode" />
                    <input type="hidden" id="deliveryType" name="deliveryType" value="ship"/>
                </td>
            </tr>
        <tr class="shipping delivery_date" data-lead-time="<?= $firstAvailable->format('Y-m-d\T00:00:00') ?>" data-postcode-info="<?= htmlspecialchars($jsonPostcodeData) ?>" data-delivery-lead-time="<?= $leadTime; ?>" data-excluded-delivery-dates="<?= htmlspecialchars($jsonExcludeDates); ?>">
            <th>Delivery Date</th>
            <td data-title="">
                <input type="text" readonly="readonly" id="deliveryDate" name="deliveryDate" value ="<?= $deliveryDate ?>" placeholder="Select a delivery date" />
                <p id="no-delivery-message" style="display:none">Sorry, delivery is not available to this postcode. Please select a pickup location or enter a different postcode.</p>
            </td>
        </tr>
        <?php
        } else {
            echo '<input type="hidden" id="deliveryType" name="deliveryType" value="pickup"/>';
        }
    }

    public function setDeliveryDate()
    {
        $deliveryDate = filter_input(INPUT_POST, 'delivery_date', FILTER_SANITIZE_STRING);
        WC()->session->set('sh_delivery_date', $deliveryDate);
        
        wp_send_json_success([]);
    }
    public function setDeliveryPostcode()
    {
        $deliveryPostcode = filter_input(INPUT_POST, 'delivery_postcode', FILTER_SANITIZE_STRING);
        WC()->session->set('sh_delivery_postcode', $deliveryPostcode);
        
        wp_send_json_success([]);
    }

    /**
     * custom_options_handle
     *
     * Adds custom_options post data to cart item if it exists.
     *
     * @param  array $cart
     * @return array
     */
    public static function custom_options_handle($cart)
    {
        if (!empty($_POST['custom_options'])) {
            $cart['custom-options'] = $_POST['custom_options'];
        }

        return $cart;
    }

    /**
     * custom_options_item_data
     *
     * Add custom-options data to item in cart if it exists.
     *
     * @param  array $item_data
     * @param  array $cart_item
     * @return array
     */
    public static function custom_options_item_data($item_data, $cart_item)
    {
        if (isset($cart_item['custom-options']) && $cart_item['custom-options']) {
            foreach ($cart_item['custom-options'] as $choice) {
                $item_data[] = [
                    'name'  => 'Hide:',
                    'value' => esc_textarea($choice)
                ];
            }
        }
        return $item_data;
    }

    /**
     * custom_options_add_meta
     *
     * Add custom-options meta data to order items if it exists.
     * We set every individual option as a unique meta data for admin display,
     * but also the entire array as a hidden meta data for programmatic use.
     *
     * @param  WC_Order_Item_Product $item
     */
    public static function custom_options_add_meta($item)
    {
        foreach ($item as $cart_item) {
            if (isset($cart_item['custom-options']) && $cart_item['custom-options']) {
                foreach ($cart_item['custom-options'] as $i => $option) {
                    $title = 'Option ' . ($i + 1);
                    $item->add_meta_data($title, $option, true);
                }

                $item->add_meta_data('_custom_options', $cart_item['custom-options'], true);
            }
        }
    }

    /**
     * custom_login_errors
     *
     * Adds custom error messages to WordPress login form and WooCommerce My Account.
     *
     * @return error
     */
    public function login_error_message($error) 
    {
        $error = "The username / email or password you have entered is incorrect. Please double check your username / email for typos and try again. Please note after 5 failed attempts your account will be blocked for security purposes. <br><br> If you cannot remember your password please reset it using the 'Forgotten your password?' link below";

        return $error;
    }
}

?>
