<?php
/**
 * The Template for displaying products in a product category. Simply includes the archive template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/taxonomy-product_cat.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); 

$termParent = isset(get_queried_object()->parent) ? get_term(get_queried_object()->parent) : '';
if(is_product_category('supermarket')) {
	get_template_part( 'woocommerce/b2-taxonomy-archive' );
} else if ((has_term('supermarket', 'product_cat') && is_product()) || 
	(!is_wp_error($termParent) && isset($termParent->slug) && $termParent->slug == 'supermarket')) {
	$term_object = get_queried_object();
	$productPosition = get_field('products_position', $term_object);
	$archive = false;
	include(locate_template( 'woocommerce/b2-category-section.php' ));
	wp_reset_postdata();
	Blue2\Scruffy\Utils::flexibleLoopCategories("sections", $term_object);
} else {
	wc_get_template( 'archive-product.php' );
}

get_footer( 'shop' ); 
