<?php
global $post;
if(get_sub_field('recipe')) {
	$post = get_sub_field('recipe');
} elseif(get_field('recipe')) {
	$post = get_field('recipe');
}

setup_postdata( $post ); 
$postTypeCTA = get_post_type() === "recipe" ? 'View Recipe' : 'View More';
$productImageId = get_post_thumbnail_id();
$productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'general-tile') : 
[get_template_directory_uri() . "/dist/images/default-800-605.jpg"];
$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: $title;

if(get_field('products_used')) {
    $productsUsed = get_field('products_used'); 
	$productsUsedArray = [];
	$count = 0; 
    foreach($productsUsed as $products) { 
		$count++; 
		if($count <= 3) {
			$productImageId = get_post_thumbnail_id($products->ID);
			$squareImage = get_field('square_image', $products->ID) ? wp_get_attachment_image_src(get_field('square_image', $products->ID), 'award-square') : wp_get_attachment_image_src($productImageId, 'award-square');
			// $squareImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'award-square') : [get_template_directory_uri() . "/dist/images/default-800-605.jpg"];
			$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: get_the_title();
			
			array_push($productsUsedArray, [
				'title' => get_the_title($products->ID),
				'url' => get_the_permalink($products->ID),
				'square_img' => $squareImage[0],
				'img_alt' => $productImageAlt
			]);
		}
    }
} 
?>

<figure class="tile tile--caption tile--img-hover tile--caption-recipe ">
	<a href="<?php the_permalink(); ?>">
		<span class="cta btn-graphic"><?= $postTypeCTA; ?></span>
		<img class="img-fluid" src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />

		<figcaption class="tile--caption--text">
			<h3><?php the_title(); ?></h3>

			<?php if(get_field('time_to_prepare')) { ?>
				<p class="prep-time"><i class="fas fa-user-clock" title="Preparation time"></i> <span><?php the_field('time_to_prepare'); ?></span></p>
			<?php } ?>

			<?php if(get_field('cooking_time')) { ?>
				<p class="cook-time"><i class="fas fa-stopwatch" title="Cooking time"></i> <span><?php the_field('cooking_time'); ?></span></p>
			<?php } ?>

			
			
			<?php
				$starReview = get_field("star_rating") ?? "";
			?>
			<?php 
			if ($starReview !== "") {
			?>
				<div class="standout-link">
					<p class="lead-text">Customer rating</p>
				</div>
				<?php if ($starReview !== "" && $starReview !== 0) { ?>
					<div class="stars-rating">
						<?php
							$starCount = 0;
							while ($starCount < $starReview) {
						?>
								<i class="fas fa-star"></i>
						<?php
								$starCount++;
							}
						?>
					</div>
				<?php } ?>
			<?php } else { ?>
				<div class="write-review">
					<?php
					$cleanTitle = strtolower(get_the_title());
					$cleanTitle = preg_replace("/[^a-z0-9_\s-]/", "", $cleanTitle);
					$cleanTitle = preg_replace("/[\s-]+/", " ", $cleanTitle);
					$cleanTitle = preg_replace("/[\s_]/", "-", $cleanTitle);
					?>
					<a href="<?php echo esc_url(home_url('/')); ?>review-our-recipes?recipeId=<?= get_the_id(); ?>&recipeTitle=<?= $cleanTitle; ?>" class="write-review-image"></a>
				</div>
			<?php } ?>
		</figcaption>

	</a>
</figure>

<?php if(isset($productsUsedArray) && $productsUsedArray) { ?>

	<div class="products-used-circles tile--caption-recipe-circles">
		<?php 
		foreach($productsUsedArray as $productUsed) { 
			?>
			<a href="<?= $productUsed['url']; ?>" class="products-used-circle">
				<img class="img-fluid" src="<?= $productUsed['square_img']; ?>" alt="<?= $productUsed['img_alt'];?>"/>
			</a>
		<?php 
			} 
		?>
	</div>

<?php } ?>

<?php wp_reset_postdata();