<?php
/**
 * Order details table shown in emails.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates/Emails
 * @version     3.2.0
 */

if (! defined('ABSPATH')) {
    exit;
}

$text_align = is_rtl() ? 'right' : 'left';

// do_action( 'woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email );?>

<?php
$shippingDetails = Blue2\Scruffy\Controllers\WoocommerceController::getShippingDetails($order);
$pickupDate = strtotime($shippingDetails['Pickup Date']);
$pickupDateFormat = date('jS M Y', $pickupDate);
$isDelivery = Blue2\Scruffy\Controllers\WoocommerceController::getOrderType($order) == 'ship';
?>

<p><strong><?= $isDelivery ? 'Delivery' : 'Collection' ?> date: <span class="orange-letters"><?= $pickupDateFormat; ?></span></strong></p>
<p><strong><?= $isDelivery ? 'Delivery from' : 'Collection place' ?>: <span class="orange-letters"><a href="https://thescottishbutcher.com/local-butchers-perth-auchterarder/locations-opening-times/" target="_blank" ><?= $shippingDetails['Pickup Location']; ?></a></span></strong></p>

<?php Blue2\Scruffy\Controllers\WoocommerceController::b2ViewOrder($order); ?>