<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.2.0
 */

if (! defined('ABSPATH')) {
    exit;
}

ob_start();
?>

<div class="woocommerce-order">

	<?php if ($order) : ?>

		<?php if ($order->has_status('failed')) : ?>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php _e('Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce'); ?></p>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
				<a href="<?php echo esc_url($order->get_checkout_payment_url()); ?>" class="button pay"><?php _e('Pay', 'woocommerce') ?></a>
				<?php if (is_user_logged_in()) : ?>
					<a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="button pay"><?php _e('My account', 'woocommerce'); ?></a>
				<?php endif; ?>
			</p>

		<?php else : ?>

			<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters('woocommerce_thankyou_order_received_text', __('Thank you. Your order has been received.', 'woocommerce'), $order); ?></p>

			<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

				<li class="woocommerce-order-overview__order order">
					<?php _e('Order number:', 'woocommerce'); ?>
					<strong><?php echo $order->get_order_number(); ?></strong>
				</li>

				<li class="woocommerce-order-overview__date date">
					<?php

                    $orderType = Blue2\Scruffy\Controllers\WoocommerceController::getOrderType($order);
                    

                    if ($orderType == 'ship') {
                        $orderTypeLabel = 'Delivery Date:';
                        $shippingDetails = Blue2\Scruffy\Controllers\WoocommerceController::getDeliveryDetails($order);
                        $orderDate = $shippingDetails['Delivery Date'];
						
                    } else {
                        $orderTypeLabel = 'Collection Date:';
                        $shippingDetails = Blue2\Scruffy\Controllers\WoocommerceController::getShippingDetails($order);
                        $orderDate = $shippingDetails['Pickup Date'];
                    }
                    
                    _e($orderTypeLabel, 'woocommerce'); ?>
					<?php
					
                    $pickupDate = strtotime($orderDate);
                    $pickupDateFormat = date('jS M Y', $pickupDate);
                    ?>
					<strong><?= $pickupDateFormat; ?></strong>
				</li>

				<?php if (is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email()) : ?>
					<li class="woocommerce-order-overview__email email">
						<?php _e('Email:', 'woocommerce'); ?>
						<strong><?php echo $order->get_billing_email(); ?></strong>
					</li>
				<?php endif; ?>

				<li class="woocommerce-order-overview__total total">
					<?php _e('Approx:', 'woocommerce'); ?>
					<strong><?php echo $order->get_formatted_order_total(); ?></strong>
				</li>

				<?php if ($order->get_payment_method_title()) : ?>
					<li class="woocommerce-order-overview__payment-method method">
						<?php _e('Payment method:', 'woocommerce'); ?>
						<strong><?php echo wp_kses_post($order->get_payment_method_title()); ?></strong>
					</li>
				<?php endif; ?>

			</ul>
			<script>
			gtag('event', 'purchase', {
				"transaction_id": "<?= $order->get_order_number(); ?>",
				"affiliation": "<?= $shippingDetails['Pickup Location']; ?>",
				"value": <?= $order->get_total(); ?>,
				"currency": "GBP",
				"tax": 0,
				"shipping": 0,
				"items": [
					<?php
                    foreach ($order->get_items() as $itemKey => $item) {
                        $product = $item->get_product(); ?>
					{ 
					"id": "<?= $product->get_sku(); ?>",
					"name": "<?= $product->get_name(); ?>",
					"quantity": <?= $item->get_quantity(); ?>,
					"price": '<?= $item->get_total(); ?>'
					},
					<?php
                    } ?>
				]
			});
			</script>
		<?php endif; ?>

		<?php
        do_action('woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id());
        
        if (get_field('content_for_price_disclaimer', 'option')) {
            the_field('content_for_price_disclaimer', 'option');
        }
        
        // do_action( 'woocommerce_thankyou', $order->get_id() );
        Blue2\Scruffy\Controllers\WoocommerceController::b2ViewOrder($order);
        ?>

	<?php else : ?>

		<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters('woocommerce_thankyou_order_received_text', __('Thank you. Your order has been received.', 'woocommerce'), null); ?></p>

	<?php endif; ?>

</div>

<?php


$buffer = ob_get_flush();

set_transient('sh_order_'.$order->get_order_number(), $buffer);
wp_mail('acowan@blue2.co.uk', 'Debug simon howie - order #'.$order->get_order_number(), $buffer, ['Content-Type: text/html; charset=UTF-8']);
