<?php

use Blue2\Scruffy\Controllers\StoreController;

$popularProducts = get_field('popular_products');
?>

    <div class="container container-wide">
        <?php if (function_exists('yoast_breadcrumb')) {
    yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
} ?>
        <h1><?= get_the_title(); ?></h1>
        <?php the_content(); ?>
    </div>
    <!--    <span class="accent">Popular Right Now</span>-->
    <section class="where-to-buy-new">
        <div class="featured-products section--product-slider-supermarket">
            <p class="accent" id="where-to-buy-accent">
                <img src="<?= get_template_directory_uri() ?>/dist/images/feature-text-brush-stroke.svg" alt="">
                <span class="white-text">Popular Right Now</span>
                <span class="white-text d-none">Select a Product <img class="arrow-prompt" src="<?= get_template_directory_uri() ?>/dist/images/arrow-up-prompt.png" alt=""><span>
            </p>
            <div class="wrapper">
                <span class="prompt" id="locationPropmpt"><span>Please Enter a Location to Start</span></span>
                <div class="swiper-container swiper-products-supermarket">
                    <div class="swiper-wrapper">
                        <?php
                        foreach ($popularProducts as $product) { ?>
                            <?php
                                $myterms = get_the_terms($product->ID, 'product_cat');
                                $myRange =  $myterms && isset($myterms[0]) ? $myterms[0]->term_id : '';
                            ?>  
                            <div class="swiper-slide">
                                <div class="swiper-slide map-filter add-location-prompt" data-range="<?= $myRange;?>" data-id="<?= $product->ID ?>">
                                    <img src="<?= get_the_post_thumbnail_url($product->ID);?>" alt="" data-range="<?= $myRange;?>" data-id="<?= $product->ID; ?>">
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <!-- Add Arrows -->
                    <div class="swiper-button-next swiper-button-next--range"></div>
                    <div class="swiper-button-prev swiper-button-prev--range"></div>
                    <div class="mask"></div>
                </div>
            </div>
        </div>
        <div class="controls">
            <form action="" class="search-form form-group" id="map-search-form">
                <div class="col-lg-5 align-items-center">
                    <label for="search" class="mt-lg">Where do you want to search?</label>
                </div>
                <div class="col-lg-7">
                    <input type="text" class="form-control postcode-input" name="search"
                           id="search-input"
                           placeholder="Enter postcode, town, location" required>
                    <button type="button" class="transparent" id="reset">RESET</button>
                </div>
                <div class="col-lg-5">
                    <div class="form-group">
                        <label for="store-filter">Which stores?</label>
                        <select name="store" class="form-control" id="store-filter">
                            <option selected value="0">Select all please</option>
                            <?php StoreController::getStoreTerms(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="form-group ">
                        <label for="product-filter">Which product range?</label>
                        <div class="inline-inputs">
                            <select name="product_range" class="form-control" id="product-range">
                                <option selected value="0">Show all products</option>
                                <?php StoreController::outputSupermarketProductCategories(); ?>
                            </select>
                            <input type="submit" class="btn btn-primary"
                                   onclick="gtag('event', 'click go', {'event_category':'use stockist finder', 'event_label': 'find a stockist'});"
                                   id="submit-search" value="GO">
                        </div>
                    </div>
                </div>
            </form>
            <div class="individual-product-filter-container" id="individual-product-filter-container">
                <div class="col-12">
                    <label for="individual-product-filter">Got a specific product in mind? Select from range</label>
                    <select id="individual-product-filter">
                        <option>Show All Products</option>
                        <?php
                            foreach ($popularProducts as $product) { ?>
                                <option value="<?= $product->ID; ?>">
                                        <?= get_the_title($product->ID); ?>
                                </option>
                            <?php } ?>
                    </select>
                </div>
                <img id="range-prompt" src="<?= get_template_directory_uri() ?>/dist/images/input-prompt.png" alt="select a range">
            </div>
            <div class="results">
                <p>Results panel</p>
                <div id="result-container">
                    <p class="default">No current results. Please input or amend your search above.</p>
                </div>
            </div>
        </div>
        <div class="map-contain" id="map-contain">
            <i class="fas fa-spinner fa-3x fa-spin"></i>
            <div class="map" id="map"></div>
        </div>
    </section>
    <!--MORE CONTENT-->
<?php Blue2\Scruffy\Utils::flexibleLoop();
