<?php 
if(get_sub_field('categories')) { 
    $categories = get_sub_field('categories');
    ?>
    <section class="section section--product-slider-supermarket" >
        <div class="container">
            <div class="row">
                <h1>In the Supermarkets</h1>
                <div class="swiper-container swiper-products-supermarket">
                    <div class="swiper-wrapper">
                        <?php 
                        foreach($categories as $category) { 
                            $productImageId = get_term_meta( $category->term_id, 'thumbnail_id', true );
                            $productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'award-square') : [get_template_directory_uri() . "/dist/images/product-package-240-175.png"];
                            $productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: $category->name;
                            ?>
                            <div class="swiper-slide">
                                <a href="<?= get_term_link($category->term_id); ?>">
                                    <img src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
                                    <p><?= $category->name; ?></p>
                                </a>
                            </div>
                        <?php } ?>
                    </div>

                    <!-- Add Arrows -->
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                    <div class="mask"></div>
                </div>
            </div>
        </div>
    </section>
<?php } wp_reset_postdata();