<?php
if($pattern == 'accreditation' && get_sub_field('accreditation')) {
	global $post;
	$post = get_sub_field('accreditation');
	setup_postdata( $post ); 
	$title = get_the_title();
	$productImageId = get_post_thumbnail_id();
} else {
	$productImageId = get_sub_field('image');
}

$label = get_sub_field('call_to_action_label') ?: "View More";
$url = get_sub_field('call_to_action_url');

$productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'general-tile') : false;
$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: '';

if($productImage !== false) {
?>
	<figure class="tile tile--basic tile--img-hover">
		<?php if($label && $url) { ?>
			<a href="<?= $url; ?>">
				<span class="cta btn-graphic"><?= $label; ?></span>
		<?php } ?>

		<img class="img-fluid" src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />

		<?php if($label && $url) { ?>
			</a>
		<?php } ?>
	</figure>
<?php } wp_reset_postdata();