<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wc_print_notices();

do_action( 'woocommerce_before_cart' );

if(get_field('content_for_price_disclaimer', 'option')) { ?>
    <div class="disclaimer"><?php the_field('content_for_price_disclaimer', 'option'); ?></div>
<?php } ?>

<?php
$basketHasLimitedProduct = false;
$basketHasPrePaymentProduct = false;
foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
	$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
	if (get_field('limited_availability', $product_id) == true) {
		$basketHasLimitedProduct = true;

		$orderFrom = get_field('allow_order_from', $product_id);
		$orderTo = get_field('allow_order_to', $product_id);

		if (get_field('requires_pre_payment', $product_id) == true) {
			$basketHasPrePaymentProduct = true;
		}
	}
}

	if ($basketHasLimitedProduct == true) {
?>
		<div class="disclaimer"><p>There are items in your basket that are only available on certain dates. Please amend your collection/ delivery date to reflect this or remove the limited time only products from your basket.</p></div>
<?php
	}
	if ($basketHasPrePaymentProduct == true) {
?>
		<div class="disclaimer"><p>Please note your basket contains an item needs paid for in advance to secure your pre order. A member of the team with contact you for payment shortly after you checkout. Any other items in your basket will be paid for as normal, on collection or prior to delivery.</p></div>
<?php
	}
?>

<form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
	<?php do_action( 'woocommerce_before_cart_table' ); ?>

	<table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">
		<thead>
			<tr>
				<th class="product-remove">&nbsp;</th>
				<th class="product-thumbnail">&nbsp;</th>
				<th class="product-name"><?php _e( 'Product', 'woocommerce' ); ?></th>
				<th class="product-price"><?php _e( 'Price', 'woocommerce' ); ?></th>
				<th class="product-quantity"><?php _e( 'Quantity', 'woocommerce' ); ?></th>
				<th class="product-subtotal"><?php _e( 'Total', 'woocommerce' ); ?></th>
				<th class="product-subtotal"><?php _e( 'Limited', 'woocommerce' ); ?></th>
				<th class="product-subtotal"><?php _e( 'Requires pre-pay', 'woocommerce' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php do_action( 'woocommerce_before_cart_contents' ); ?>

			<?php
			$conflicts = false;
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
				$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

				$isLimitedProduct = false;
				$isPrePaymentProduct = false;
				if (get_field('limited_availability', $product_id) == true) {
					$isLimitedProduct = true;
					if (get_field('requires_pre_payment', $product_id) == true) {
						$isPrePaymentProduct = true;
					}
				}

				if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
					$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );

					$additionalClasses = Blue2\Scruffy\Controllers\WoocommerceController::checkProductLocation(get_field('available_location', $cart_item['product_id']));
					if($additionalClasses == 'not-available') {
                        $conflicts = true;
                        Blue2\Scruffy\Controllers\WoocommerceController::addOverlayText($cart_item['product_id'], get_field('available_location', $cart_item['product_id'])[0], "cart-page");
					}
					// $additionalClasses = Blue2\Scruffy\Controllers\WoocommerceController::checkProductAvailability($cart_item['product_id']);
					?>
					<tr class="woocommerce-cart-form__cart-item <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?> <?= $additionalClasses; ?> postId-<?= $cart_item['product_id']; ?>">

						<td class="product-remove">
							<?php
								echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
									'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
									esc_url( WC()->cart->get_remove_url( $cart_item_key ) ),
									__( 'Remove this item', 'woocommerce' ),
									esc_attr( $product_id ),
									esc_attr( $_product->get_sku() )
								), $cart_item_key );
							?>
						</td>

						<td class="product-thumbnail">
							<?php
								$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

								if ( ! $product_permalink ) {
									echo $thumbnail;
								} else {
									printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail );
								}
							?>
						</td>

						<td class="product-name" data-title="<?php esc_attr_e( 'Product', 'woocommerce' ); ?>">
							<?php
								if ( ! $product_permalink ) {
									echo apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) . '&nbsp;';
								} else {
									echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key );
								}

								// Meta data
								echo WC()->cart->get_item_data( $cart_item );

								// Backorder notification
								if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
									echo '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'woocommerce' ) . '</p>';
								}
							?>
						</td>

						<td class="product-price" data-title="<?php esc_attr_e( 'Price', 'woocommerce' ); ?>">
							<?php
								echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
							?>
						</td>

						<td class="product-quantity" data-title="<?php esc_attr_e( 'Quantity', 'woocommerce' ); ?>">
							<?php
								if ( $_product->is_sold_individually() ) {
									$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
								} else {
									$product_quantity = woocommerce_quantity_input( array(
										'input_name'  => "cart[{$cart_item_key}][qty]",
										'input_value' => $cart_item['quantity'],
										'max_value'   => $_product->get_max_purchase_quantity(),
										'min_value'   => '0',
									), $_product, false );
								}

								echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item );
							?>
						</td>

						<td class="product-subtotal" data-title="<?php esc_attr_e( 'Total', 'woocommerce' ); ?>">
							<?php
								echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
							?>
						</td>
						<td class="product-subtotal" data-title="<?php esc_attr_e( 'Limited', 'woocommerce' ); ?>">
							<?php
								if ($isLimitedProduct == true) {
							?>
									<span class="woocommerce-Price-amount amount"><bdi>Yes</bdi></span>
							<?php
								} else {
							?>
									<span class="woocommerce-Price-amount amount"><bdi>No</bdi></span>
							<?php
								}
							?>
						</td>
						<td class="product-subtotal" data-title="<?php esc_attr_e( 'Requires-pre-payment', 'woocommerce' ); ?>">
							<?php
								if ($isLimitedProduct == true && $isPrePaymentProduct == true) {
							?>
									<span class="woocommerce-Price-amount amount"><bdi>Yes</bdi></span>
							<?php
								} else {
							?>
									<span class="woocommerce-Price-amount amount"><bdi>No</bdi></span>
							<?php
								}
							?>
						</td>
					</tr>
					<?php
				}
			}
			?>

			<?php do_action( 'woocommerce_cart_contents' ); ?>

			<tr>
				<td colspan="8" class="actions">

					<?php if ( wc_coupons_enabled() ) { ?>
						<div class="coupon">
							<label for="coupon_code"><?php _e( 'Coupon:', 'woocommerce' ); ?></label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" /> <input type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>" />
							<?php do_action( 'woocommerce_cart_coupon' ); ?>
						</div>
					<?php } ?>

					<?php
					if($conflicts === false) {
						do_action( 'woocommerce_proceed_to_checkout' );
					} else {
						echo "<span class='conflict-message'>" . get_field('cart_conflict_message', 'option') . "</span>";
					}
					?>

					<input type="submit" class="button" name="update_cart" value="<?php esc_attr_e( 'Update cart', 'woocommerce' ); ?>" />

					<?php do_action( 'woocommerce_cart_actions' ); ?>

					<?php wp_nonce_field( 'woocommerce-cart' ); ?>
				</td>
			</tr>

			<?php do_action( 'woocommerce_after_cart_contents' ); ?>
		</tbody>
	</table>
	<?php do_action( 'woocommerce_after_cart_table' ); ?>
</form>

<div class="cart-collaterals">
	<?php
		/**
		 * woocommerce_cart_collaterals hook.
		 *
		 * @hooked woocommerce_cross_sell_display
		 * @hooked woocommerce_cart_totals - 10
		 */
	 	do_action( 'woocommerce_cart_collaterals' );
	?>
</div>


<?php do_action( 'woocommerce_after_cart' ); ?>
