<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

$additionalClasses = '';

/** Check for chosen location */
$additionalClasses = Blue2\Scruffy\Controllers\WoocommerceController::checkProductLocation(get_field('available_location'));

if($additionalClasses == 'not-available') {
	Blue2\Scruffy\Controllers\WoocommerceController::addOverlayText($product->get_id(), get_field('available_location')[0], "product");
}
/** Check if item is in the cart */
$productId = $product->get_id();
$inCart = "";
foreach(WC()->cart->get_cart() as $key => $val ) {
	$_product = $val['data'];

	if($productId == $_product->get_id() ) {
		$inCart = "in-cart";
		break;
	}
}
$additionalClasses = $additionalClasses . " " . $inCart;

if(get_field('special_offer') == true) {
	$additionalClasses = $additionalClasses . " product_special_offer ";
}

/** Check for categories with date for availability */
$categories = wp_get_post_terms($product->get_id(), 'product_cat');
$now = current_time('d/m/Y');
$limited = false;


foreach($categories as $category) {

	if(get_field('limited_availability', $category) == true) {
		$limited = true;
		$orderFrom = get_field('allow_order_from', $category);
		$orderUntil = get_field('allow_order_until', $category);
		$collectionFrom = get_field('allow_collection_from', $category);
		$collectionUntil = get_field('allow_collection_until', $category);
		break;
	}

}

$isLimitedAvailablityProduct = get_field('limited_availability', $productId) ?? false;

if ($isLimitedAvailablityProduct !== "" && $isLimitedAvailablityProduct !== false) {
	$productOrderFrom = get_field('allow_order_from', $productId);
	$productOrderUntil = get_field('allow_order_until', $productId);
	$productCollectionFrom = get_field('allow_collection_from', $productId);
	$productCollectionUntil = get_field('allow_collection_until', $productId);
}


/** Check for allowed to order */
if(isset($orderFrom) && isset($orderUntil) && $limited === true) {
	if($now >= $orderFrom && $now < $orderUntil) {
		$show = true;
	} else {
		$show = false;
	}
} else {
	$show = true;
}

/** Check for allowed to order product*/
if(isset($productOrderFrom) && isset($productOrderUntil) && $isLimitedAvailablityProduct === true) {
	if($now >= $productOrderFrom && $now < $productOrderUntil) {
		$productShow = true;
	} else {
		$productShow = false;
	}
} else {
	$productShow = true;
}

if($show === true && $productShow === true) {
?>
	<li <?php post_class($additionalClasses); ?>>
		<?php if(get_field('info_box')) { ?>
			<!-- <span class="info-trigger"><strong>&#33;</strong></span> -->
			<span class="info-trigger"><i class="fal fa-info-circle"></i></span>
			<span class="info-message">
				<p><?php the_field('info_box'); ?></p>
			</span>
		<?php } ?>
		<?php
		/**
		 * woocommerce_before_shop_loop_item hook.
		 *
		 * @hooked woocommerce_template_loop_product_link_open - 10
		 */
		do_action( 'woocommerce_before_shop_loop_item' );

		/**
		 * woocommerce_before_shop_loop_item_title hook.
		 *
		 * @hooked woocommerce_show_product_loop_sale_flash - 10
		 * @hooked woocommerce_template_loop_product_thumbnail - 10
		 */
		do_action( 'woocommerce_before_shop_loop_item_title' );

		/**
		 * woocommerce_shop_loop_item_title hook.
		 *
		 * @hooked woocommerce_template_loop_product_title - 10
		 */
		do_action( 'woocommerce_shop_loop_item_title' );?>

<?php
		/**
		 * woocommerce_after_shop_loop_item_title hook.
		 *
		 * @hooked woocommerce_template_loop_rating - 5
		 * @hooked woocommerce_template_loop_price - 10
		 */
		do_action( 'woocommerce_after_shop_loop_item_title' );

		/**
		 * woocommerce_after_shop_loop_item hook.
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 5
		 * @hooked woocommerce_template_loop_add_to_cart - 10
		 */
		do_action( 'woocommerce_after_shop_loop_item' );
		
		if($inCart == "in-cart") {
			//echo "Item is in the cart";
		}

		woocommerce_template_single_add_to_cart();
		?>
	</li>
<?php }