/* eslint-disable */

/* global ajaxUrl */

const checkIfEmpty = function() {
    if ($('.cart_item').length === 0) {
        $('.empty-cart').show();
    } else {
        $('.empty-cart').hide();
    }
};

const checkIfAllAvailable = function() {
    if ($('tr.cart_item.not-available').length > 0) {
        $('.checkout-button').addClass('disable');
    }
};

const qtyUpdates = function() {
    $('form.checkout').on('click', 'input.qty', () => {
        const data = {
            action: 'update_order_review',
            security: wc_checkout_params.update_order_review_nonce,
            post_data: $('form.checkout').serialize()
        };
        jQuery.post(ajaxUrl, data, () => {
            $('body').trigger('update_checkout');
        });
    });
};

const formatter = new Intl.NumberFormat('en-UK', {
    style: 'currency',
    currency: 'GBP',
    minimumFractionDigits: 2
});

function animateSpinner(el, animation, complete) {
    if (el.data('animating')) {
        el.removeClass(el.data('animating')).data('animating', null);
        el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
    }
    el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
    el.data('animationTimeout', setTimeout(function() {
        animation === 'remove' && el.remove();
        complete && complete();
    }, parseFloat(el.css('animation-duration')) * 1000));
}

function addSpinner(el, static_pos) {
    let spinner = el.children('.spinner');
    if (spinner.length && !spinner.hasClass('spinner-remove')) {
        return null;
    }
    !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
    animateSpinner(spinner, 'add');
}

function removeSpinner(el, complete) {
    const spinner = el.children('.spinner');
    spinner.length && animateSpinner(spinner, 'remove', complete);
}

const addApproxHTML = function() {
    const form = $(this).closest('form.cart')[0];
    const select = $(form).find('select');
    const valueOfSelect = $(select).find(':selected')
        .val();
    console.log(valueOfSelect);
    $('.approx-price').remove();
    if (valueOfSelect === '') {
        $('.approx-price').remove();
    } else if ($(form).hasClass('price-approx')) {
        $(form).find('.single_variation_wrap')
            .append('<span class="approx-price approx-price-variations">Approx.</span>');
    }
};

const showPriceAfterRefresh = function() {

    $('.checkout-button').on('click', function() {
        gtag('event', 'Checkout', { 'event_category':'Shopping cart', 'event_label': 'proceed to checkout' });
    });
    $('.remove_from_cart_button').on('click', function() {
        gtag('event', 'remove item', { 'event_category':'Shopping cart', 'event_label': 'remove from shopping cart' });
    });

    /*global wc_add_to_cart_variation_params */
    ;(function ( $, window, document, undefined ) {

        /**
         * VariationForm class which handles variation forms and attributes.
         */
        var VariationForm = function( $form ) {
            this.$form                = $form;
            this.$attributeFields     = $form.find( '.variations select' );
            this.$singleVariation     = $form.find( '.single_variation' );
            this.$singleVariationWrap = $form.find( '.single_variation_wrap' );
            this.$resetVariations     = $form.find( '.reset_variations' );
            this.$product             = $form.closest( '.product' );
            this.variationData        = $form.data( 'product_variations' );
            this.useAjax              = false === this.variationData;
            this.xhr                  = false;

            // Initial state.
            this.$singleVariationWrap.show();
            this.$form.off( '.wc-variation-form' );

            // Methods.
            this.getChosenAttributes    = this.getChosenAttributes.bind( this );
            this.findMatchingVariations = this.findMatchingVariations.bind( this );
            this.isMatch                = this.isMatch.bind( this );
            this.toggleResetLink        = this.toggleResetLink.bind( this );

            // Events.
            $form.on( 'click.wc-variation-form', '.reset_variations', { variationForm: this }, this.onReset );
            $form.on( 'reload_product_variations', { variationForm: this }, this.onReload );
            $form.on( 'hide_variation', { variationForm: this }, this.onHide );
            $form.on( 'show_variation', { variationForm: this }, this.onShow );
            $form.on( 'click', '.single_add_to_cart_button', { variationForm: this }, this.onAddToCart );
            $form.on( 'reset_data', { variationForm: this }, this.onResetDisplayedVariation );
            $form.on( 'reset_image', { variationForm: this }, this.onResetImage );
            $form.on( 'change.wc-variation-form', '.variations select', { variationForm: this }, this.onChange );
            $form.on( 'found_variation.wc-variation-form', { variationForm: this }, this.onFoundVariation );
            $form.on( 'check_variations.wc-variation-form', { variationForm: this }, this.onFindVariation );
            $form.on( 'update_variation_values.wc-variation-form', { variationForm: this }, this.onUpdateAttributes );

            // Init after gallery.
            setTimeout( function() {
                $form.trigger( 'check_variations' );
                $form.trigger( 'wc_variation_form' );
            }, 100 );
        };

        /**
         * Reset all fields.
         */
        VariationForm.prototype.onReset = function( event ) {
            event.preventDefault();
            event.data.variationForm.$attributeFields.val( '' ).change();
            event.data.variationForm.$form.trigger( 'reset_data' );
        };

        /**
         * Reload variation data from the DOM.
         */
        VariationForm.prototype.onReload = function( event ) {
            var form           = event.data.variationForm;
            form.variationData = form.$form.data( 'product_variations' );
            form.useAjax       = false === form.variationData;
            form.$form.trigger( 'check_variations' );
        };

        /**
         * When a variation is hidden.
         */
        VariationForm.prototype.onHide = function( event ) {
            event.preventDefault();
            event.data.variationForm.$form.find( '.single_add_to_cart_button' ).removeClass( 'wc-variation-is-unavailable' ).addClass( 'disabled wc-variation-selection-needed' );
            event.data.variationForm.$form.find( '.woocommerce-variation-add-to-cart' ).removeClass( 'woocommerce-variation-add-to-cart-enabled' ).addClass( 'woocommerce-variation-add-to-cart-disabled' );
        };

        /**
         * When a variation is shown.
         */
        VariationForm.prototype.onShow = function( event, variation, purchasable ) {
            event.preventDefault();
            if ( purchasable ) {
                event.data.variationForm.$form.find( '.single_add_to_cart_button' ).removeClass( 'disabled wc-variation-selection-needed wc-variation-is-unavailable' );
                event.data.variationForm.$form.find( '.woocommerce-variation-add-to-cart' ).removeClass( 'woocommerce-variation-add-to-cart-disabled' ).addClass( 'woocommerce-variation-add-to-cart-enabled' );
            } else {
                event.data.variationForm.$form.find( '.single_add_to_cart_button' ).removeClass( 'wc-variation-selection-needed' ).addClass( 'disabled wc-variation-is-unavailable' );
                event.data.variationForm.$form.find( '.woocommerce-variation-add-to-cart' ).removeClass( 'woocommerce-variation-add-to-cart-enabled' ).addClass( 'woocommerce-variation-add-to-cart-disabled' );
            }
        };

        /**
         * When the cart button is pressed.
         */
        VariationForm.prototype.onAddToCart = function( event ) {
            if ( $( this ).is('.disabled') ) {
                event.preventDefault();

                if ( $( this ).is('.wc-variation-is-unavailable') ) {
                    window.alert( wc_add_to_cart_variation_params.i18n_unavailable_text );
                } else if ( $( this ).is('.wc-variation-selection-needed') ) {
                    window.alert( wc_add_to_cart_variation_params.i18n_make_a_selection_text );
                }
            }
        };

        /**
         * When displayed variation data is reset.
         */
        VariationForm.prototype.onResetDisplayedVariation = function( event ) {
            var form = event.data.variationForm;
            form.$product.find( '.product_meta' ).find( '.sku' ).wc_reset_content();
            form.$product.find( '.product_weight' ).wc_reset_content();
            form.$product.find( '.product_dimensions' ).wc_reset_content();
            form.$form.trigger( 'reset_image' );
            form.$singleVariation.slideUp( 200 ).trigger( 'hide_variation' );
        };

        /**
         * When the product image is reset.
         */
        VariationForm.prototype.onResetImage = function( event ) {
            event.data.variationForm.$form.wc_variations_image_update( false );
        };

        /**
         * Looks for matching variations for current selected attributes.
         */
        VariationForm.prototype.onFindVariation = function( event ) {
            var form              = event.data.variationForm,
                attributes        = form.getChosenAttributes(),
                currentAttributes = attributes.data;

            if ( attributes.count === attributes.chosenCount ) {
                if ( form.useAjax ) {
                    if ( form.xhr ) {
                        form.xhr.abort();
                    }
                    form.$form.block( { message: null, overlayCSS: { background: '#fff', opacity: 0.6 } } );
                    currentAttributes.product_id  = parseInt( form.$form.data( 'product_id' ), 10 );
                    currentAttributes.custom_data = form.$form.data( 'custom_data' );
                    form.xhr                      = $.ajax( {
                        url: wc_add_to_cart_variation_params.wc_ajax_url.toString().replace( '%%endpoint%%', 'get_variation' ),
                        type: 'POST',
                        data: currentAttributes,
                        success: function( variation ) {
                            if ( variation ) {
                                form.$form.trigger( 'found_variation', [ variation ] );
                            } else {
                                form.$form.trigger( 'reset_data' );
                                form.$form.find( '.single_variation' ).after( '<p class="wc-no-matching-variations woocommerce-info">' + wc_add_to_cart_variation_params.i18n_no_matching_variations_text + '</p>' );
                                form.$form.find( '.wc-no-matching-variations' ).slideDown( 200 );
                            }
                        },
                        complete: function() {
                            form.$form.unblock();
                        }
                    } );
                } else {
                    form.$form.trigger( 'update_variation_values' );

                    var matching_variations = form.findMatchingVariations( form.variationData, currentAttributes ),
                        variation           = matching_variations.shift();

                    if ( variation ) {
                        form.$form.trigger( 'found_variation', [ variation ] );
                    } else {
                        form.$form.trigger( 'reset_data' );
                        form.$form.find( '.single_variation' ).after( '<p class="wc-no-matching-variations woocommerce-info">' + wc_add_to_cart_variation_params.i18n_no_matching_variations_text + '</p>' );
                        form.$form.find( '.wc-no-matching-variations' ).slideDown( 200 );
                    }
                }
            } else {
                form.$form.trigger( 'update_variation_values' );
                form.$form.trigger( 'reset_data' );
            }

            // Show reset link.
            form.toggleResetLink( attributes.chosenCount > 0 );
        };

        /**
         * Triggered when a variation has been found which matches all attributes.
         */
        VariationForm.prototype.onFoundVariation = function( event, variation ) {
            var form           = event.data.variationForm,
                $sku           = form.$product.find( '.product_meta' ).find( '.sku' ),
                $weight        = form.$product.find( '.product_weight' ),
                $dimensions    = form.$product.find( '.product_dimensions' ),
                $qty           = form.$singleVariationWrap.find( '.quantity' ),
                purchasable    = true,
                variation_id   = '',
                template       = false,
                $template_html = '';

            if ( variation.sku ) {
                $sku.wc_set_content( variation.sku );
            } else {
                $sku.wc_reset_content();
            }

            if ( variation.weight ) {
                $weight.wc_set_content( variation.weight_html );
            } else {
                $weight.wc_reset_content();
            }

            if ( variation.dimensions ) {
                $dimensions.wc_set_content( variation.dimensions_html );
            } else {
                $dimensions.wc_reset_content();
            }

            form.$form.wc_variations_image_update( variation );

            if ( ! variation.variation_is_visible ) {
                template = wp.template( 'unavailable-variation-template' );
            } else {
                template     = wp.template( 'variation-template' );
                variation_id = variation.variation_id;
            }

            $template_html = template( {
                variation: variation
            } );
            $template_html = $template_html.replace( '/*<![CDATA[*/', '' );
            $template_html = $template_html.replace( '/*]]>*/', '' );

            form.$singleVariation.html( $template_html );
            form.$form.find( 'input[name="variation_id"], input.variation_id' ).val( variation.variation_id ).change();

            // Hide or show qty input
            if ( variation.is_sold_individually === 'yes' ) {
                $qty.find( 'input.qty' ).val( '1' ).attr( 'min', '1' ).attr( 'max', '' );
                $qty.hide();
            } else {
                $qty.find( 'input.qty' ).attr( 'min', variation.min_qty ).attr( 'max', variation.max_qty );
                $qty.show();
            }

            // Enable or disable the add to cart button
            if ( ! variation.is_purchasable || ! variation.is_in_stock || ! variation.variation_is_visible ) {
                purchasable = false;
            }

            // Reveal
            if ( $.trim( form.$singleVariation.text() ) ) {
                form.$singleVariation.slideDown( 200 ).trigger( 'show_variation', [ variation, purchasable ] );
            } else {
                form.$singleVariation.show().trigger( 'show_variation', [ variation, purchasable ] );
            }
        };

        /**
         * Triggered when an attribute field changes.
         */
        VariationForm.prototype.onChange = function( event ) {
            var form = event.data.variationForm;

            form.$form.find( 'input[name="variation_id"], input.variation_id' ).val( '' ).change();
            form.$form.find( '.wc-no-matching-variations' ).remove();

            if ( form.useAjax ) {
                form.$form.trigger( 'check_variations' );
            } else {
                form.$form.trigger( 'woocommerce_variation_select_change' );
                form.$form.trigger( 'check_variations' );
                $( this ).blur();
            }

            // Custom event for when variation selection has been changed
            form.$form.trigger( 'woocommerce_variation_has_changed' );
        };

        /**
         * Escape quotes in a string.
         * @param {string} string
         * @return {string}
         */
        VariationForm.prototype.addSlashes = function( string ) {
            string = string.replace( /'/g, '\\\'' );
            string = string.replace( /"/g, '\\\"' );
            return string;
        };

        /**
         * Updates attributes in the DOM to show valid values.
         */
        VariationForm.prototype.onUpdateAttributes = function( event ) {
            var form              = event.data.variationForm,
                attributes        = form.getChosenAttributes(),
                currentAttributes = attributes.data;

            if ( form.useAjax ) {
                return;
            }

            // Loop through selects and disable/enable options based on selections.
            form.$attributeFields.each( function( index, el ) {
                var current_attr_select     = $( el ),
                    current_attr_name       = current_attr_select.data( 'attribute_name' ) || current_attr_select.attr( 'name' ),
                    show_option_none        = $( el ).data( 'show_option_none' ),
                    option_gt_filter        = ':gt(0)',
                    attached_options_count  = 0,
                    new_attr_select         = $( '<select/>' ),
                    selected_attr_val       = current_attr_select.val() || '',
                    selected_attr_val_valid = true;

                // Reference options set at first.
                if ( ! current_attr_select.data( 'attribute_html' ) ) {
                    var refSelect = current_attr_select.clone();

                    refSelect.find( 'option' ).removeAttr( 'disabled attached' ).removeAttr( 'selected' );

                    current_attr_select.data( 'attribute_options', refSelect.find( 'option' + option_gt_filter ).get() ); // Legacy data attribute.
                    current_attr_select.data( 'attribute_html', refSelect.html() );
                }

                new_attr_select.html( current_attr_select.data( 'attribute_html' ) );

                // The attribute of this select field should not be taken into account when calculating its matching variations:
                // The constraints of this attribute are shaped by the values of the other attributes.
                var checkAttributes = $.extend( true, {}, currentAttributes );

                checkAttributes[ current_attr_name ] = '';

                var variations = form.findMatchingVariations( form.variationData, checkAttributes );

                // Loop through variations.
                for ( var num in variations ) {
                    if ( typeof( variations[ num ] ) !== 'undefined' ) {
                        var variationAttributes = variations[ num ].attributes;

                        for ( var attr_name in variationAttributes ) {
                            if ( variationAttributes.hasOwnProperty( attr_name ) ) {
                                var attr_val         = variationAttributes[ attr_name ],
                                    variation_active = '';

                                if ( attr_name === current_attr_name ) {
                                    if ( variations[ num ].variation_is_active ) {
                                        variation_active = 'enabled';
                                    }

                                    if ( attr_val ) {
                                        // Decode entities and add slashes.
                                        attr_val = $( '<div/>' ).html( attr_val ).text();

                                        // Attach.
                                        new_attr_select.find( 'option[value="' + form.addSlashes( attr_val ) + '"]' ).addClass( 'attached ' + variation_active );
                                    } else {
                                        // Attach all apart from placeholder.
                                        new_attr_select.find( 'option:gt(0)' ).addClass( 'attached ' + variation_active );
                                    }
                                }
                            }
                        }
                    }
                }

                // Count available options.
                attached_options_count = new_attr_select.find( 'option.attached' ).length;

                // Check if current selection is in attached options.
                if ( selected_attr_val && ( attached_options_count === 0 || new_attr_select.find( 'option.attached.enabled[value="' + form.addSlashes( selected_attr_val ) + '"]' ).length === 0 ) ) {
                    selected_attr_val_valid = false;
                }

                // Detach the placeholder if:
                // - Valid options exist.
                // - The current selection is non-empty.
                // - The current selection is valid.
                // - Placeholders are not set to be permanently visible.
                if ( attached_options_count > 0 && selected_attr_val && selected_attr_val_valid && ( 'no' === show_option_none ) ) {
                    new_attr_select.find( 'option:first' ).remove();
                    option_gt_filter = '';
                }

                // Detach unattached.
                new_attr_select.find( 'option' + option_gt_filter + ':not(.attached)' ).remove();

                // Finally, copy to DOM and set value.
                current_attr_select.html( new_attr_select.html() );
                current_attr_select.find( 'option' + option_gt_filter + ':not(.enabled)' ).prop( 'disabled', true );

                // Choose selected value.
                if ( selected_attr_val ) {
                    // If the previously selected value is no longer available, fall back to the placeholder (it's going to be there).
                    if ( selected_attr_val_valid ) {
                        current_attr_select.val( selected_attr_val );
                    } else {
                        current_attr_select.val( '' ).change();
                    }
                } else {
                    current_attr_select.val( '' ); // No change event to prevent infinite loop.
                }
            });

            // Custom event for when variations have been updated.
            form.$form.trigger( 'woocommerce_update_variation_values' );
        };

        /**
         * Get chosen attributes from form.
         * @return array
         */
        VariationForm.prototype.getChosenAttributes = function() {
            var data   = {};
            var count  = 0;
            var chosen = 0;

            this.$attributeFields.each( function() {
                var attribute_name = $( this ).data( 'attribute_name' ) || $( this ).attr( 'name' );
                var value          = $( this ).val() || '';

                if ( value.length > 0 ) {
                    chosen ++;
                }

                count ++;
                data[ attribute_name ] = value;
            });

            return {
                'count'      : count,
                'chosenCount': chosen,
                'data'       : data
            };
        };

        /**
         * Find matching variations for attributes.
         */
        VariationForm.prototype.findMatchingVariations = function( variations, attributes ) {
            var matching = [];
            for ( var i = 0; i < variations.length; i++ ) {
                var variation = variations[i];

                if ( this.isMatch( variation.attributes, attributes ) ) {
                    matching.push( variation );
                }
            }
            return matching;
        };

        /**
         * See if attributes match.
         * @return {Boolean}
         */
        VariationForm.prototype.isMatch = function( variation_attributes, attributes ) {
            var match = true;
            for ( var attr_name in variation_attributes ) {
                if ( variation_attributes.hasOwnProperty( attr_name ) ) {
                    var val1 = variation_attributes[ attr_name ];
                    var val2 = attributes[ attr_name ];
                    if ( val1 !== undefined && val2 !== undefined && val1.length !== 0 && val2.length !== 0 && val1 !== val2 ) {
                        match = false;
                    }
                }
            }
            return match;
        };

        /**
         * Show or hide the reset link.
         */
        VariationForm.prototype.toggleResetLink = function( on ) {
            if ( on ) {
                if ( this.$resetVariations.css( 'visibility' ) === 'hidden' ) {
                    this.$resetVariations.css( 'visibility', 'visible' ).hide().fadeIn();
                }
            } else {
                this.$resetVariations.css( 'visibility', 'hidden' );
            }
        };

        /**
         * Function to call wc_variation_form on jquery selector.
         */
        $.fn.wc_variation_form = function() {
            new VariationForm( this );
            return this;
        };

        /**
         * Stores the default text for an element so it can be reset later
         */
        $.fn.wc_set_content = function( content ) {
            if ( undefined === this.attr( 'data-o_content' ) ) {
                this.attr( 'data-o_content', this.text() );
            }
            this.text( content );
        };

        /**
         * Stores the default text for an element so it can be reset later
         */
        $.fn.wc_reset_content = function() {
            if ( undefined !== this.attr( 'data-o_content' ) ) {
                this.text( this.attr( 'data-o_content' ) );
            }
        };

        /**
         * Stores a default attribute for an element so it can be reset later
         */
        $.fn.wc_set_variation_attr = function( attr, value ) {
            if ( undefined === this.attr( 'data-o_' + attr ) ) {
                this.attr( 'data-o_' + attr, ( ! this.attr( attr ) ) ? '' : this.attr( attr ) );
            }
            if ( false === value ) {
                this.removeAttr( attr );
            } else {
                this.attr( attr, value );
            }
        };

        /**
         * Reset a default attribute for an element so it can be reset later
         */
        $.fn.wc_reset_variation_attr = function( attr ) {
            if ( undefined !== this.attr( 'data-o_' + attr ) ) {
                this.attr( attr, this.attr( 'data-o_' + attr ) );
            }
        };

        /**
         * Reset the slide position if the variation has a different image than the current one
         */
        $.fn.wc_maybe_trigger_slide_position_reset = function( variation ) {
            var $form                = $( this ),
                $product             = $form.closest( '.product' ),
                $product_gallery     = $product.find( '.images' ),
                reset_slide_position = false,
                new_image_id = ( variation && variation.image_id ) ? variation.image_id : '';

            if ( $form.attr( 'current-image' ) !== new_image_id ) {
                reset_slide_position = true;
            }

            $form.attr( 'current-image', new_image_id );

            if ( reset_slide_position ) {
                $product_gallery.trigger( 'woocommerce_gallery_reset_slide_position' );
            }
        };

        /**
         * Sets product images for the chosen variation
         */
        $.fn.wc_variations_image_update = function( variation ) {
            var $form             = this,
                $product          = $form.closest( '.product' ),
                $product_gallery  = $product.find( '.images' ),
                $gallery_nav      = $product.find( '.flex-control-nav' ),
                $gallery_img      = $gallery_nav.find( 'li:eq(0) img' ),
                $product_img_wrap = $product_gallery.find( '.woocommerce-product-gallery__image, .woocommerce-product-gallery__image--placeholder' ).eq( 0 ),
                $product_img      = $product_img_wrap.find( '.wp-post-image' ),
                $product_link     = $product_img_wrap.find( 'a' ).eq( 0 );

            if ( variation && variation.image && variation.image.src && variation.image.src.length > 1 ) {
                if ( $gallery_nav.find( 'li img[src="' + variation.image.thumb_src + '"]' ).length > 0 ) {
                    $gallery_nav.find( 'li img[src="' + variation.image.thumb_src + '"]' ).trigger( 'click' );
                    $form.attr( 'current-image', variation.image_id );
                    return;
                } else {
                    $product_img.wc_set_variation_attr( 'src', variation.image.src );
                    $product_img.wc_set_variation_attr( 'height', variation.image.src_h );
                    $product_img.wc_set_variation_attr( 'width', variation.image.src_w );
                    $product_img.wc_set_variation_attr( 'srcset', variation.image.srcset );
                    $product_img.wc_set_variation_attr( 'sizes', variation.image.sizes );
                    $product_img.wc_set_variation_attr( 'title', variation.image.title );
                    $product_img.wc_set_variation_attr( 'alt', variation.image.alt );
                    $product_img.wc_set_variation_attr( 'data-src', variation.image.full_src );
                    $product_img.wc_set_variation_attr( 'data-large_image', variation.image.full_src );
                    $product_img.wc_set_variation_attr( 'data-large_image_width', variation.image.full_src_w );
                    $product_img.wc_set_variation_attr( 'data-large_image_height', variation.image.full_src_h );
                    $product_img_wrap.wc_set_variation_attr( 'data-thumb', variation.image.src );
                    $gallery_img.wc_set_variation_attr( 'src', variation.image.thumb_src );
                    $product_link.wc_set_variation_attr( 'href', variation.image.full_src );
                }
            } else {
                $product_img.wc_reset_variation_attr( 'src' );
                $product_img.wc_reset_variation_attr( 'width' );
                $product_img.wc_reset_variation_attr( 'height' );
                $product_img.wc_reset_variation_attr( 'srcset' );
                $product_img.wc_reset_variation_attr( 'sizes' );
                $product_img.wc_reset_variation_attr( 'title' );
                $product_img.wc_reset_variation_attr( 'alt' );
                $product_img.wc_reset_variation_attr( 'data-src' );
                $product_img.wc_reset_variation_attr( 'data-large_image' );
                $product_img.wc_reset_variation_attr( 'data-large_image_width' );
                $product_img.wc_reset_variation_attr( 'data-large_image_height' );
                $product_img_wrap.wc_reset_variation_attr( 'data-thumb' );
                $gallery_img.wc_reset_variation_attr( 'src' );
                $product_link.wc_reset_variation_attr( 'href' );
            }

            window.setTimeout( function() {
                $( window ).trigger( 'resize' );
                $form.wc_maybe_trigger_slide_position_reset( variation );
                $product_gallery.trigger( 'woocommerce_gallery_init_zoom' );
            }, 20 );
        };

        $(function() {
            if ( typeof wc_add_to_cart_variation_params !== 'undefined' ) {
                $( '.variations_form' ).each( function() {
                    $( this ).wc_variation_form();
                });
            }
        });

        /**
         * Matches inline variation objects to chosen attributes
         * @deprecated 2.6.9
         * @type {Object}
         */
        var wc_variation_form_matcher = {
            find_matching_variations: function( product_variations, settings ) {
                var matching = [];
                for ( var i = 0; i < product_variations.length; i++ ) {
                    var variation    = product_variations[i];

                    if ( wc_variation_form_matcher.variations_match( variation.attributes, settings ) ) {
                        matching.push( variation );
                    }
                }
                return matching;
            },
            variations_match: function( attrs1, attrs2 ) {
                var match = true;
                for ( var attr_name in attrs1 ) {
                    if ( attrs1.hasOwnProperty( attr_name ) ) {
                        var val1 = attrs1[ attr_name ];
                        var val2 = attrs2[ attr_name ];
                        if ( val1 !== undefined && val2 !== undefined && val1.length !== 0 && val2.length !== 0 && val1 !== val2 ) {
                            match = false;
                        }
                    }
                }
                return match;
            }
        };

    })( jQuery, window, document );
};

const calculatePriceAfterRefresh = function() {
    $(() => {
        const form = $(this).closest('form.cart')[0];
        const price = $(this).closest('table')
            .attr('data-price');
        const weight = parseFloat($(form).find('.amount_needed')
            .val());
        let calculatedPrice = (price / 1000) * weight;
        calculatedPrice = Math.round(calculatedPrice * 100) / 100;

        $(form).find('.amount')
            .html(formatter.format(calculatedPrice));
    });
};

const calculateAllPricesAfterRefresh = function() {
    $(() => {
        $('.cart').each((index, form) => {
            const price = $(form).attr('data-price');
            const weight = parseFloat($(form).find('.amount_needed')
                .attr('min'));
            let calculatedPrice = (price / 1000) * weight;
            calculatedPrice = Math.round(calculatedPrice * 100) / 100;

            if (!isNaN(weight)) {
                $(form).find('.amount')
                    .html(formatter.format(calculatedPrice));
            }
            console.log(form, price, weight);
        });
    });
    /*$(() => {
        $('.variations_form').each((index, form) => {
            const price = $(this).closest('table')
                .attr('data-price');
            const weight = parseFloat($(this).find('.amount_needed')
                .attr('min'));

            console.log('this is the price: ' + price, ', This is the weight ' + weight);
            let calculatedPrice = (price / 1000) * weight;
            calculatedPrice = Math.round(calculatedPrice * 100) / 100;

            $(form).find('.amount')
                .html(formatter.format(calculatedPrice));
        });
    });*/
};
// Fragment the sidebar cart, to update it every time it is changed
const changeSidebarCart = function() {
    $(document.body).trigger('update_checkout');
    checkIfEmpty();
};

// Change amount of people fed depending on the inputted weight
const weightToPeople = function() {
    const form = $(this).closest('form.cart')[0];
    const weight = parseFloat($(form)
        .find('.amount_needed')
        .val()
    );
    const weightForOne = $(form).find('table')
        .data('feedone');
    const people = weight / weightForOne;
    const peopleFed = parseInt(people, 10);
    $(form).find('.no_people_fed')
        .val(peopleFed);
};

// Change amount of weight shown depending on inputted amount of people
const peopleToWeight = function() {
    const form = $(this).closest('form.cart')[0];
    const people = parseFloat($(form).find('.no_people_fed')
        .val());
    const weightForOne = $(form).find('table')
        .data('feedone');
    const weight = people * weightForOne;
    const weightNeeded = parseInt(weight, 10);
    $(form).find('.amount_needed')
        .val(weightNeeded);
    $(this).closest('form.cart')
        .trigger('wc-measurement-price-calculator-update');
    $(form).trigger('wc-measurement-price-calculator-update');
};
const bindEvents = () => {
    $('.amount_needed').on('change keyup', weightToPeople);
    $('.no_people_fed').on('change keyup', peopleToWeight);
    $('#size').on('change', addApproxHTML);

    $('.no_people_fed').on('change keyup', calculatePriceAfterRefresh);
    $('.amount_needed').on('change keyup', calculatePriceAfterRefresh);

    $(() => {
        $('form.cart').each((index, form) => {
            const weightForOne = $(form).find('table')
                .data('feedone');
            const totalPrice = $(form).find('table')
                .data('price');
            const priceForOne = (totalPrice / 1000) * weightForOne;
            const newPrice = Math.round(priceForOne * 100) / 100;
            $(form).find('.product_price')
                .html('<span class="amount">' + formatter.format(newPrice) + '</span>');
        });
    });


    $(() => {
        $('form.cart').each((index, form) => {
            const weightForOne = $(form).find('table')
                .data('feedone');
            const minFeed = $(form).find('table')
                .data('minfeed');
            const minWeight = weightForOne * minFeed;
            $(form).find('#weight_needed')
                .val(minWeight);
            $(form).find('#no_people_fed')
                .val(minFeed);
            $(form).trigger('wc-measurement-price-calculator-update');
        });
    });


    $('.form-ajax').submit(e => {
        let addbutton = $(e.target).find('button');
        addbutton.css("pointer-events", "none");
        let addbuttonIcon = $(addbutton).find('svg')
        addbuttonIcon.removeClass();
        addbuttonIcon.addClass("svg-inline--fa fa-circle-notch fa-w-16 fa-spin");
        let variables = String($(e.target).serialize());
        const id = $(e.target).find('button')
            .data('productid');
        variables = variables.concat('&add-to-cart=');
        variables = variables.concat(id);
        $.post('', variables, () => {
            $('body').trigger('added_to_cart');
        });
        checkIfEmpty();
        checkIfAllAvailable();
        return false;
    });
};
let updateProducts = false;

const ajaxRefresh = function() {
    if (updateProducts) {
        const page = $('.loadMore').attr('data-page');
        const category = $('.loadMore').attr('data-category');
        const tag = $('.loadMore').attr('data-tag');
        const search = $('.loadMore').attr('data-search');

        $.ajax({
            type: 'POST',
            url: ajaxUrl,
            dataType: 'html',
            data: {
                action: 'getAjaxPosts',
                pageNumber: page,
                category,
                tag,
                search
            },
            success: response => {
                $('.products').html(response);
                bindEvents();
                showPriceAfterRefresh();
                calculatePriceAfterRefresh();
                $('.amount_needed').on('change keyup', () => {
                    weightToPeople();
                });
                $('.no_people_fed').on('change keyup', () => {
                    peopleToWeight();
                });
                calculateAllPricesAfterRefresh();
            },
            error: () => {
                alert('Sorry, there was a problem!');
            },
            complete: () => {
            }
        });
        updateProducts = false;
    }
};

const fragmentRefresh = function() {
    $(document.body).trigger('wc_fragment_refresh');
};

const woocommerce = () => {
    $('form.checkout').on('click', 'input.qty', () => {
        const data = {
            action: 'update_order_review',
            security: wc_checkout_params.update_order_review_nonce,
            post_data: $('form.checkout').serialize()
        };
        jQuery.post(ajaxUrl, data, () => {
            $('body').trigger('update_checkout');
        });
    });


    $('body').on('added_to_cart removed_from_cart', changeSidebarCart);

    $('body').on('update_cart', ajaxRefresh);
    $('body').on('change', '.pickup-location-lookup', () => {
        updateProducts = true;
    });


    $('body').on('update_checkout', ajaxRefresh);
    $('body').on('update_checkout', fragmentRefresh);

    $('body').on('added_to_cart', () => {
        $('.empty-cart').hide();
        if ($('.woocommerce-checkout').length === 0) {
            $('.sidebar-cart').append('<form class="checkout woocommerce-checkout"><table class="shop_table woocommerce-checkout-review-order-table"></table></form>');
            $('.empty-cart').hide();
        }
        
        $(".products button").each(function(){
            $( this ).css( "pointer-events", "all" );
            
            let addbuttonIcon = $(this).find('svg')
            addbuttonIcon.removeClass();
            addbuttonIcon.addClass("svg-inline--fa fa-plus fa-w-14");
        });
    });

    $('body').on('removed_from_cart', () => {
        if ($('.cart_item').length === 1) {
            $('.empty-cart').show();
        }
    });

    $('body.archive').trigger('update_checkout');
    bindEvents();
    checkIfEmpty();
    checkIfAllAvailable();
    qtyUpdates();

    $('body').on('click', '.checkout-button', e => {
        if ($('.pickup-location-lookup').val() === '') {
            e.preventDefault();
            $('.select2-selection').addClass('border-warning');
            $('.checkout-button').addClass('disabled');
            $('html, body').animate({
                scrollTop: $('.pickup_location').offset().top
            }, 2000);
        }
        return;
    });

    if ($('.woocommerce-error').length > 0) {
        // $('.woocommerce-error').css('display', 'none');
    }

    let hasReachedBottom = false;
    let isUpdating = false;
    let bottomOffset;

    const loadMoreProds  = function() {
        $(() => {
            hasReachedBottom = true;
            let page = $('.products .loadMore:last').last().attr('data-page');
            let category = $('.products .loadMore:last').last().attr('data-category');
            let newCategory = $('.products .loadMore:last').last().attr('data-new-category');
            if (newCategory) {
                page = 1;
                $('.loadMore').removeAttr('data-new-category');
            }
            const tag = $('.loadMore').attr('data-tag');
            const search = $('.loadMore').attr('data-search');

            if (hasReachedBottom && !isUpdating) {

                isUpdating = true;
                $.ajax({
                    url: ajaxUrl,
                    data: {
                        action: 'loadMorePosts',
                        pageNumber: page,
                        category,
                        tag,
                        search,
                    },
                    type: 'POST',
                    beforeSend: () => {
                        addSpinner($('.products'));
                    },
                    success: data => {
                        if (data) {
                            $('.products').append(data);
                            page++;
                            qtyUpdates();
                            bindEvents();
                            showPriceAfterRefresh();
                            calculatePriceAfterRefresh();
                            $('.amount_needed').on('change keyup', () => {
                                weightToPeople();
                            });
                            $('.no_people_fed').on('change keyup', () => {
                                peopleToWeight();
                            });
                            calculateAllPricesAfterRefresh();
                            window.doingAjax = false;
                            return false;
                        }
                    },
                    complete: () => {
                        $('.loadMore').attr('data-page', page);
                        isUpdating = false;
                        removeSpinner($('.products'));
                    }
                });
            }
            return false;
        });
    };

    const observer = new MutationObserver(function(mutations_list) {
        mutations_list.forEach(function(mutation) {
            mutation.addedNodes.forEach(function(added_node) {
                if(added_node.id == 'forLoadMore') {
                    // loadMoreProds();
                }
            });
        });
    });
    observer.observe(document.querySelector("#products"), { subtree: false, childList: true });

    $(window).on('scroll', function() {
        if (window.innerWidth <= 992) {
            bottomOffset = 3000;
        } else {
            bottomOffset = 1500;
        }

        if ($(document).scrollTop() > ($(document).height() - bottomOffset) && $('.end').length < 1) {
            // loadMoreProds();
        }
    });
};

$(document).scroll(() => {
    $('.hasDatepicker').blur();
    $('.hasDatepicker').datepicker('hide');
});

$('.drawerToggle').click(() => {
    $('.drawer').toggleClass('open');
});

export default woocommerce;
