<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     2.0.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header('shop'); ?>

<?php
/**
 * woocommerce_before_main_content hook.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');

get_template_part('templates/parts/product-search');
?>
<div class="loaders"></div>
<header class="woocommerce-products-header">

    <div class="container">
        <a class="click-and-collect-search drawerToggle" href="javascript:void(0)">Search products</a>

        <?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
            <div class="row">
                <div class="col-lg-4">
                    <h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
                    <?php
                    if (is_shop()) {
                        $description = get_field('main_shop_page_description', 'option');
                        $thumbnail_id = get_field('main_shop_page_background_image', 'option');
                    } else {
                        $term_object = get_queried_object();
                        $description = $term_object->description;
                        $thumbnail_id = get_term_meta($term_object->term_id, 'thumbnail_id', true) ?: get_field('image', $term_object);
                    }
                    $bgImage = $thumbnail_id ? wp_get_attachment_url($thumbnail_id, 'full') :
                        wp_get_attachment_url(get_field('main_shop_page_background_image', 'option'), 'full');
                    $altImage = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true) ?: '';

                    if ($description) {
                        ?>
                        <div class="description"><?= $description; ?></div>
                        <?php
                    }

                    // if(get_field('content_for_price_disclaimer', 'option')) {
                    ?>
                    <!-- <div class="disclaimer"><?php // the_field('content_for_price_disclaimer', 'option'); ?></div> -->
                    <?php
                    // }
                    /**
                     * woocommerce_archive_description hook.
                     *
                     * @hooked woocommerce_taxonomy_archive_description - 10
                     * @hooked woocommerce_product_archive_description - 10
                     */
                    do_action('woocommerce_archive_description');
                    ?>
                </div>

            </div>
        <?php endif; ?>

    </div>
</header>

<div class="container container--fluid-until-lg">
    <div class="row">
        <div class="col-lg-4 sidebar-cart">
            <h2 class="accent cart-title">Shopping Cart</h2>
            <form class="checkout woocommerce-checkout">
                <?php woocommerce_order_review(); ?>
            </form>

            <div class="empty-cart">
                <?php the_field('content_for_empty_basket', 'option'); ?>
            </div>
        </div>

        <div class="col-lg-8 click-collect-products">
            <script>var ajaxUrl = "<?= admin_url('admin-ajax.php'); ?>";</script>
            <ul class="products columns-4" id="products">

            <?php

            //Click and collect cat id
            $currentProductCat = 17;

            // Check if subcategory page
            global $wp_query;
            if (isset($wp_query->get_queried_object()->term_id)) {
                $currentProductCat = $wp_query->get_queried_object()->term_id;
            }

            $args = array(
                'taxonomy'   => "product_cat",
                'parent'   => $currentProductCat,
            );
            // Get categories
            $product_categories = get_terms($args);
            $productCats = [];

            // Add all subcategories if 'click and collect'
            foreach ($product_categories as $product_category) {
                $productCatId = $product_category->term_id;
                $productCats[] = $productCatId;
            }
            // Add category's own id if it is a subcat already
            if ($productCats == []) {
                $productCats[] = $currentProductCat;
            }
            ?>

            <?php if (have_posts()) : ?>

                <?php

                $product_ids = [];
                $counter = 0;

                foreach ($productCats as $prodCat) {

                    $args = array(
                        'post_type'             => 'product',
                        'paged'                 => 1,
                        'post_status'           => 'publish',
                        'ignore_sticky_posts'   => 1,
                        'posts_per_page'        => '12',
                        'tax_query'             => array(
                            array(
                                'taxonomy'      => 'product_cat',
                                'field' 		=> 'term_id',
                                'terms'         => $prodCat,
                                'operator'      => 'IN'
                            ),
                        ),
                        'meta_key' => 'sorting_order',
                        'orderby' => [
                            'meta_value_num' => 'asc',
                            'title' => 'asc',
                        ],
                    );
                    $products = new WP_Query($args);

                    while ( $products->have_posts() ) {

                        $products->the_post();
                        $product_ids[] = get_the_ID();
                        $product = wc_get_product(get_the_ID());
                        wc_get_template_part('content', 'product');
                    }
                ?>
                    <!-- This is for the aJax -->
                    <div class="row">
                        <div class="col-md-12"> <?php
                            global $wp_query;
                            isset($wp_query->query_vars['product_cat']) ? $category = $wp_query->query_vars['product_cat'] : $category = 'click-collect';
                            isset($wp_query->query_vars['product_tag']) ? $tag = $wp_query->query_vars['product_tag'] : $tag = '';
                            echo '<div data-category="' . $prodCat . '" data-tag="' . $tag . '" data-search="' . get_search_query() . '" data-page="2" class="loadMore"></div>'; ?>
                        </div>
                    </div>

                <?php

                    $counter++;

                    break;
                }

                $prodCount = [$counter];

                //update our product options
                if ( get_option('products') ) {
                    update_option( 'products', implode(',', $product_ids));
                } else {
                    add_option( 'products', implode(',', $product_ids));
                }
                //update our product categories
                if ( get_option('product_categories') ) {
                    update_option( 'product_categories', implode(',', $productCats));
                } else {
                    add_option( 'product_categories', implode(',', $productCats));
                }
                //update our product categories
                if ( get_option('count') ) {
                    update_option( 'count', implode(',', $prodCount));
                } else {
                    add_option( 'count', implode(',', $prodCount));
                }

                ?>

            <?php elseif (!woocommerce_product_subcategories(['before' => woocommerce_product_loop_start(false), 'after' => woocommerce_product_loop_end(false)])) : ?>

                <?php
                /**
                 * woocommerce_no_products_found hook.
                 *
                 * @hooked wc_no_products_found - 10
                 */
                do_action('woocommerce_no_products_found');
                ?>

            <?php endif; ?>

            <?php
            /**
             * woocommerce_after_main_content hook.
             *
             * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
             */
            do_action('woocommerce_after_main_content');
            ?>
        </div>
    </div>
</div>
<script type='text/javascript'>
    var urlParams = new URLSearchParams(window.location.search);

    if(urlParams.has('selectLocation')){
        var validateInterval = setInterval(function(){
            if($('.select2-selection').length>0){
                $('.select2-selection').addClass('border-warning');
                $('.wc-proceed-to-checkout .checkout-button').trigger('click');
                $('.pickup-location-field em').css('color','red');
                clearInterval(validateInterval);
            }
        },1000);
    }
</script>
<?php get_footer('shop'); ?>
