<?php 
$sliders = get_field('sliders');
if($sliders) {
    shuffle($sliders);
    $randomSlider = $sliders[0];

    $image = isset($randomSlider['image']) ? wp_get_attachment_image_src($randomSlider['image'], 'full') : '';
    $imageAlt = get_post_meta($randomSlider['image'], '_wp_attachment_image_alt', true) ?: '';
    $ctaLabel = isset($randomSlider['call_to_action_label']) ? $randomSlider['call_to_action_label'] : '';
    $ctaUrl = isset($randomSlider['call_to_action_url']) ? $randomSlider['call_to_action_url'] : '';
    $ctaUrlNewTab = isset($randomSlider['call_to_action_new_tab']) ? $randomSlider['call_to_action_new_tab'] : '';
}

if(get_field('separate_slides')) {
?>
    <section class="section section--large-banner" >
        <div class="swiper-container swiper-large-banner">
            <div class="swiper-wrapper">
                <?php if($sliders) { ?>
                    <div class="swiper-slide">
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-6">
                                    <div class="banner-msg">
                                        <h1><?php the_title(); ?></h1>

                                        <?php if(get_field('caption')) { ?>
                                            <p><?php the_field('caption'); ?></p>
                                        <?php } ?>

                                        <?php if(get_field('call_to_action_label') && get_field('call_to_action_url')) { ?>
                                            <a href="<?php the_field('call_to_action_url'); ?>" class="btn-graphic" <?= get_field('call_to_action_new_tab') == true ? 'target="_blank"' : '' ; ?>><?php the_field('call_to_action_label'); ?></a>
                                        <?php } ?>
                                    </div>
                                    <a class="video-trigger__mobile" target="_blank" href="https://d1ssu070pg2v9i.cloudfront.net/pex/simonhowie/2019/06/25134046/home-page-video-mobile.mp4">
                                        <span class="sr-only">Watch ‘Our Home’ Video</span>
                                        <span><i class="fas fa-play"></i></span>
                                    </a>

                                    <a class="d-none d-xl-block video-trigger" href="#">
                                        <span class="sr-only">Play Video</span>
                                        <span><i class="fas fa-play"></i></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                            <?php if(isset($ctaLabel) && $ctaLabel && isset($ctaUrl)) { ?>
                            <div class="feature-cta text-right">
                                <div class="container">
                                    <a class="arrow-cta" href="<?= $ctaUrl; ?>"  <?= $ctaUrlNewTab == true ? 'target="_blank"' : '' ; ?>><?= $ctaLabel; ?></a>
                                </div>
                            </div>
                        <?php } ?>
                        
                        <?php if($image) { ?>
                            <div class="feature-product">
                                <img class="img-fluid" src="<?= $image[0]; ?>" alt="<?= $imageAlt; ?>" />
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
                <?php 
                if(have_rows('separate_slides')) {
                    while(have_rows('separate_slides')) {
                        the_row();

                        $bsSlideClass = get_sub_field('bs_class') ?? "";
                    ?>
                        <div class="swiper-slide <?= $bsSlideClass; ?>">
                            <div class="container">
                                <div class="row">
                                    <div class="col-sm-7 col-xl-6">
                                        <?php if(get_sub_field('campaign_content')) { ?>
                                            <div class="banner-msg">
                                                <?php the_sub_field('campaign_content'); ?>                           
                                            </div>
                                        <?php } ?>
                                        
                                    </div>
                                </div>
                            </div>
                            <?php if(get_sub_field('campaign_cta_label') && get_sub_field('campaign_cta_url')) { ?>
                                <div class="feature-cta text-right">
                                    <div class="container">
                                        <a class="arrow-cta" href="<?php the_sub_field('campaign_cta_url'); ?>" <?= get_sub_field('campaign_cta_new_tab') == true ? 'target="_blank"' : '' ; ?>><?php the_sub_field('campaign_cta_label'); ?></a>
                                    </div>
                                </div>
                            <?php } ?>
                            <?php 
                            $campaignImage = get_sub_field('campaign_image') ? wp_get_attachment_image_src(get_sub_field('campaign_image'), 'full') : '';
                            if($campaignImage) {
                            ?>
                                <div class="feature-product text-right">
                                    <img class="img-fluid" src="<?= $campaignImage[0]; ?>" alt="alt tag" />
                                </div>
                            <?php } ?>

                            <?php if(have_rows('featured_images')) { $count = 0; ?>
                                <div class="container product-ctas">
                                    <div class="row">
                                        <div class="col-lg-8 col-xl-6">
                                            <div class="row">
                                                <?php
                                                while(have_rows('featured_images')) {
                                                    the_row();
                                                    $count++;
                                                    $additionalClass = $count === 2 ? 'delay' : '';
                                                    $featuredImage = get_sub_field('image') ? wp_get_attachment_image_src(get_sub_field('image'), 'full') : '';
                                                    if($featuredImage) {
                                                        $alt = get_post_meta(get_sub_field('image'), '_wp_attachment_image_alt', TRUE) ?: "Simon Howie";
                                                    ?>
                                                        <div class="col <?= $additionalClass; ?>">
                                                            <a href="<?php the_sub_field('url'); ?>" >
                                                                <img class="img-fluid" src="<?= $featuredImage[0]; ?>" alt="<?= $alt; ?>"/>
                                                            </a>
                                                        </div>
                                                <?php } } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            <?php } ?>
                        </div>
                    <?php 
                    } 
                } 
                ?>

            </div>
            <div class="pagination-holder">
                <div class="container">
                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </div>
        <?php if(get_field('background_video')) { ?>
            <span class="video-mask"></span>
            <video class="d-none d-xl-block video-bg" autoplay loop muted width="100%" height="850">			
                <source src="<?php the_field('background_video'); ?>" type="video/mp4">	
            </video>
        <?php } ?>
    </section>
<?php } else { ?>
    <section class="section section--large-banner" >
        <div class="container">
            <div class="row">
                <div class="col-xl-6">
                    <div class="banner-msg">
                        <h1><?php the_title(); ?></h1>

                        <?php if(get_field('caption')) { ?>
                            <p><?php the_field('caption'); ?></p>
                        <?php } ?>

                        <?php if(get_field('call_to_action_label') && get_field('call_to_action_url')) { ?>
                            <a href="<?php the_field('call_to_action_url'); ?>"class="btn-graphic"><?php the_field('call_to_action_label'); ?></a>
                        <?php } ?>
                    </div>
                    <a class="video-trigger__mobile" target="_blank" href="https://d1ssu070pg2v9i.cloudfront.net/pex/simonhowie/2019/06/25134046/home-page-video-mobile.mp4">
                        <span class="sr-only">Watch ‘Our Home’ Video</span>
                        <span><i class="fas fa-play"></i></span>
                    </a>

                    <a class="d-none d-xl-block video-trigger" href="#">
                        <span class="sr-only">Play Video</span>
                        <span><i class="fas fa-play"></i></span>
                    </a>
                </div>
            </div>
        </div>
        <?php if(isset($ctaLabel) && $ctaLabel && isset($ctaUrl)) { ?>
            <div class="feature-cta text-right">
                <div class="container">
                    <a class="arrow-cta" href="<?= $ctaUrl; ?>" ><?= $ctaLabel; ?></a>
                </div>
            </div>
        <?php } ?>
        
        <?php if($image) { ?>
            <div class="feature-product">
                <img class="img-fluid" src="<?= $image[0]; ?>" alt="<?= $imageAlt; ?>" />
            </div>
        <?php } ?>

        <?php if(get_field('background_video')) { ?>
            <span class="video-mask"></span>
            <video class="d-none d-xl-block video-bg" autoplay loop muted width="100%" height="850">			
                <source src="<?php the_field('background_video'); ?>" type="video/mp4">	
            </video>
        <?php } ?>

    </section>
<?php }