<?php 
$award = get_field('related_award');

$productImageId = get_post_thumbnail_id();
$productImage = has_post_thumbnail() ? wp_get_attachment_image_src($productImageId, 'product-square') : 
			[get_template_directory_uri() . "/dist/images/default-700-700.jpg"];
$productImageAlt = get_post_meta($productImageId, '_wp_attachment_image_alt', true) ?: get_the_title();
$additionalClasses = '';
if(get_field('special_offer') == true) {
	$additionalClasses = "product_special_offer ";
}
if(get_field('limited_availability') == true) {
	$additionalClasses = "product_limited_availability ";
	if(get_field('requires_pre_payment') == true) {
		$additionalClasses = "requires_pre_payment ";
	}
}
?>

<figure class="tile tile--caption tile--img-hover tile--dark <?= $additionalClasses; ?>">
	<a href="<?php the_permalink(); ?>">
		<span class="cta btn-graphic">View Product</span>

		<?php 
		if($award) {
			$awardImage = get_field('smaller_icon', $award) ?  wp_get_attachment_image_src(get_field('smaller_icon', $award), 'thumbnail') : wp_get_attachment_image_src(get_post_thumbnail_id($award), 'thumbnail');
			$awardImageAlt = get_post_meta(get_post_thumbnail_id($award), '_wp_attachment_image_alt', true) ?: get_the_title($award);
			if($awardImage) { 
			?>
				<img class="award-thumb" src="<?= $awardImage[0]; ?>" alt="<?= $awardImageAlt; ?>" />
			<?php 
			} 
		}

		if($productImage) {
		?>
			<img class="img-fluid" 
			srcset=""
			src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
		<?php } ?>
		<figcaption class="tile--caption--text">
            <h3><?php the_title(); ?></h3>
			<?= wp_trim_words(get_the_content(), 15, '...'); ?>
		</figcaption>
	</a>
</figure>