<?php
$postsPerPage = isset($count) ? $count : 5;
$socialMedia = new WP_Query([
    'post_type' => 'social-media',
    'post_status' => 'publish',
    'posts_per_page' => $postsPerPage
]);

if ($socialMedia->have_posts()) {
    while ($socialMedia->have_posts()) {
        $socialMedia->the_post();
        $img =  wp_get_attachment_image_src(get_post_thumbnail_id(), 'fluid-length');
        $alt = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
        $url = get_field('call_to_action_url');
        switch(get_field('social_platform')) {
            case 'facebook':
                $platform = '<a class="facebook" href="' . get_field('facebook_url', 'option') . '" target="_blank"><span class="sr-only">Facebook link</span><i class="fab fa-facebook-f"></i></a>';
                break;
            case 'instagram':
                $platform = ' <a class="instagram" href="' . get_field('instagram_url', 'option') . '" target="_blank"><span class="sr-only">Instagram link</span><i class="fab fa-instagram"></i></a>';
                break;
            case 'twitter':
                $platform = ' <a class="twitter" href="' . get_field('twitter_url', 'option') . '" target="_blank"><span class="sr-only">Twitter link</span><i class="fab fa-twitter"></i></a>';
                break;
            case 'youtube':
                $platform = '<a class="youtube" href="' . get_field('youtube_url', 'option') . '" target="_blank"><span class="sr-only">Youtube link</span><i class="fab fa-youtube"></i></a>';
                break;
        };
        ?>
        <article class="row no-gutters">
            <div class="icon col-2">
                <?= $platform; ?>
            </div>
            <div class="social-post col-10">
                <a target="_blank" class="image-link" href="<?= $url; ?>" >
                    <span class="cta">View post</span>
                    <img class="img-fluid" src="<?= $img[0]; ?>" alt="<?= $alt; ?>" />
                </a>
                <?php if(!empty(get_the_content())) { ?>
                    <div class="caption">
                        <?php the_content(); ?>
                    </div>                 
                <?php } ?>           
            </div>
        </article>
        <?php
        
    } wp_reset_postdata();
} 