<?php

namespace Blue2\Scruffy;

class Utils extends \Blue2\Common\Theme\Utils
{
    /**
     * Loop over flexible field and output the correct template for each row
     *
     * @param string $fieldName
     * @return void
     */
    public static function flexibleLoopOptions($fieldName = "sections")
    {
        if (have_rows($fieldName, 'option')) {
            while (have_rows($fieldName, 'option')) {
                the_row();
                // var_dump(get_row_layout());
                get_template_part('templates/sections/' . get_row_layout());
            }
        }
    }

    public static function flexibleLoopCategories($fieldName = "sections", $category)
    {
        if (have_rows($fieldName, $category)) {
            while (have_rows($fieldName, $category)) {
                the_row();
                get_template_part('templates/' . $fieldName . '/' . get_row_layout());
            }
        }
    }

    public static function flexibleRow($fieldName)
    {
        if (have_rows($fieldName)) {
            while (have_rows($fieldName)) {
                the_row();
                get_template_part('templates/sections/' . $fieldName);
            }
        }
    }

    public static function featuredPost($postType = null)
    {

        $category = isset($_GET['category']) ? $_GET['category'] : '';
        $tag = isset($_GET['tag']) ? $_GET['tag'] : '';
        $search = isset($_GET['s']) ? $_GET['s'] : '';

        if (isset($_GET)) {
            $args = [
                'post_type' => $postType,
                'category_name' => $category,
                'tag' => $tag,
                's' => $search
            ];
        } else {
            $args = [
                'post_type' => $postType,
            ];
        }

        $featuredQuery = new \WP_Query($args);

        if (get_field('featured_'.$postType, 'option')) {
            global $post;
            $post = get_field('featured_'.$postType, 'option');
            setup_postdata($post);
            get_template_part('templates/' . get_post_type() . '/content-featured');
        } else if ($featuredQuery->have_posts()) {
            $checkFeatured = true;
            while ($featuredQuery->have_posts()) {
                $featuredQuery->the_post();
                if ($checkFeatured) {
                    $templates = [
                        'templates/' . get_post_type() . '/content-featured.php',
                        'templates/' . get_post_type() . '/content.php',
                    ];
                    locate_template($templates, true);
                    $checkFeatured = false;
                    return;
                } else {
                    get_template_part('templates/' . get_post_type() . '/content');
                }
            }
        }
    }

    public static function archiveLoopOffsetOne($postType)
    {
        $category = isset($_GET['category']) ? $_GET['category'] : '';
        $category = $postType == 'recipe' && isset(get_queried_object()->slug) ? get_queried_object()->slug : $category;
        $tag = isset($_GET['tag']) ? $_GET['tag'] : '';

        $categoryLabel = isset(get_queried_object()->taxonomy) ? get_queried_object()->taxonomy : 'category_name';
        $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;

        $featured = get_field('featured_'.$postType, 'option') ? get_field('featured_'.$postType, 'option') : '';
        $search = isset($_GET['s']) ? $_GET['s'] : '';

        if($featured) {
            $featured = [$featured->ID];
        } else {
            $recentPost = wp_get_recent_posts(['post_type' => $postType, 'numberposts' => 1, $categoryLabel => $category, 's' => $search]);
            $featured = [$recentPost[0]['ID']];
        }


        $args = [
            'post_type' => $postType,
            'status' => 'publish',
            $categoryLabel => $category,
            'tag' => $tag,
            'paged' => $paged,
            's' => $search
        ];

        $wp_query = new \WP_Query($args);

        if ($wp_query->have_posts()) {
            $count = 0;
            while ($wp_query->have_posts()) {
                $wp_query->the_post();
                $count++;
                include(locate_template('templates/' . get_post_type() . '/content.php'));
            }
        }

        wp_reset_postdata();
    }

    public static function searchResults($results)
    {
        if (isset($_GET['post_type'])) {
            $postType = $_GET['post_type'];
        } else {
            $postType = ['post', 'page', 'product', 'recipe'];
        }
        $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;

        $args = [
            'post_type' => $postType,
            's' => $results,
            'posts_per_page' => '12',
            'paged' => $paged,
            'post_status ' => 'publish'
        ];

        $customQuery = new \WP_Query( $args );

        if ($customQuery->have_posts()) {
            while ($customQuery->have_posts()) {
                $customQuery->the_post();
                get_template_part('templates/recipe/content');
            }
        } else {
            get_template_part('templates/content-no-results');
        }
        wp_reset_postdata();
    }

    public static function taxonomyWrapped($taxonomy)
    {
        if (!get_post_type()) {
            global $wp_query;
            $postType = $wp_query->query['post_type'];
        } else {
            $postType = get_post_type();
        }

        get_header();
        locate_template('templates/' . $postType . '/' . $taxonomy . '.php', true);
        get_footer();
    }

}