<?php
if (get_sub_field('tiles')) {
    $flexInstructions = get_sub_field('tiles'); ?>
<div class="section section--instructions">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-6">
                <h2 class="accent">How to Order</h2>
            </div>
            <div class="col-12 col-lg-6">
                <h2 class="accent">Good to Know</h2>
            </div>
        </div>
        <div class="accordion" id="accordionGroup">
            <div class="row accordion-titles">
                <?php
                    $i = 0;
                    foreach ($flexInstructions as $instruction) { ?>
                <div class="col-12 col-lg-3">
                    <a href="#collapse-<?= $i ?>"
                        class="btn btn-graphic--short accordion-buttons <?= $i === 0 ? 'active' : 'collapsed'; ?>"
                        data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse-<?= $i ?>">
                        <span><?= $instruction['accordion_title']; ?></span>
                    </a>
                </div>
                <?php
                        $i++;
                    } ?>
            </div>
            <div class="row accordion-group">
                <?php
                    $j = 0;
                    foreach ($flexInstructions as $instruction) { 
                    ?>
                <div data-parent="#accordionGroup" class="col-12 collapse flex-cont <?= $j === 0 ? 'show' : ''; ?>"
                    id="collapse-<?= $j ?>">
                    <?php
                            $steps = $instruction['instructions'];
                            $colClass = 'col-count-'.count($steps);
                            foreach ($steps as $step) {  ?>
                    <div class="<?=$colClass;?>">
                        <?php if($step['image_link']){?>
                            <a href="<?=$step['image_link'];?>">
                        <?php } ?>
                        <?= wp_get_attachment_image($step['image'], 'full'); ?>
                        <?php if($step['image_link']){?>
                            </a>
                        <?php } ?>
                        <span class="step-text"><?= $step['content']; ?></span>
                    </div>
                    <?php } ?>                
                    <?php if($instruction['button']){?>
                    <span class="instruction-btn-container col-12">
                       <a class="btn--instructions" href="<?=$instruction['button']['url'];?>"><span><?= $instruction['button']['title']; ?></span></a>
                    </span>
                    <?php
                        }
                    ?>
                </div>
                <?php
                    $j++;
                } ?>

            </div>
        </div>
    </div>
</div>
<?php
}