<?php
$title = get_sub_field('title') ?? "";
$background_image = get_sub_field('background_image');
$packing_images_side = get_sub_field('packing_images_side');
$packaging_images = get_sub_field('packaging_images') ?? "";
$cta_link = get_sub_field('cta_link') ?? "";
$cta_link_text = get_sub_field('cta_link_text') ?? "";

if ($packing_images_side == "left") {
    $sideClass="offset-md-1";
    $sidePackagingClass="left";
} else {
    $sideClass="offset-md-8";
    $sidePackagingClass="right";
}

?>
<section class="section section--large-prompt" >
    <?php
    if ($title !== "") {
    ?>
        <h2><?= $title ?></h2>
    <?php
    }
    ?>
    <div class="conatainer-fluid section--large-prompt-inner" style="background-image: url('<?= $background_image; ?>')">
        <img class="d-md-none" src="<?= $background_image; ?>">
        <?php
        if ($packaging_images !== "") {
        ?>
        <div class="row">
            <div class="large-prompt-packaging-images col-md-3 <?= $sideClass; ?>">
                <?php
                foreach($packaging_images as $packaging_image) {
                    // var_dump($packaging_image);
                    ?>
                    <div class="packaging-image-container">
                        <img class="packing-image" src="<?= $packaging_image['image']; ?>"></img>
                        <?php if (isset($packaging_image['icon'])) { ?>
                        <img class="packing-icon <?= $sidePackagingClass; ?>" src="<?= $packaging_image['icon']; ?>"></img>
                        <?php } ?>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
        <?php
        }
        ?>
    </div>

    <?php
    if ($cta_link_text !== "" ) {
    ?>
        <?php
        if ($cta_link !== "" ) {
        ?>
            <a href="<?= $cta_link; ?>">
        <?php
        }
        ?>
            <p class="cta_button"><?php echo $cta_link_text; ?></p>
        <?php
        if ($cta_link !== "" ) {
        ?>
            </a>
        <?php
        }
        ?>
    <?php
    }
    ?>
</section>
