<?php $bgImg = wp_get_attachment_image_src(get_field('recipe_background_image', 'option'), 'fullwidth'); ?>
<section class="section" <?php if($bgImg) { echo 'style="background-image: url(' . $bgImg[0] . ')"'; } ?>>
    <div class="container">
        <div class="row">
            <div class="col-lg-4 order-1 order-lg-1">
                <?php 
                if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                } 
                $term = get_queried_object();
                ?>
                <h1><?= $term->name; ?></h1>
                <?= $term->description; ?>
            </div>

            <div class="col-lg-8 order-4 order-lg-2">
             
            </div>
            
            <div class="col-lg-4 order-2 order-lg-3">
                <div class="dropdown">

                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Filter by time
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                        <a class="dropdown-item" href="/recipes">All</a>
                        <?php
                        $times = get_terms(['taxonomy' => 'time', 'hide_empty' => true]); 
                        foreach ($times as $time) { 
                            ?>
                            <a class="dropdown-item" href="/recipes?time=<?= $time->slug; ?>"><?= $time->name; ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <div class="col-lg-8 order-3 order-lg-4">
                <?php 
                $tags = get_terms([
                    'taxonomy' => 'recipe_tag',
                    'hide_empty' => true,
                ]); 
                if($tags) {
                    ?>
                    <div class="tag-wrapper">
                        <span>Find by tag:</span>
                        <?php foreach($tags as $tag) { ?>
                            <a href="<?= get_term_link($tag->term_id); ?>" class="tag"><?= $tag->name; ?></a>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>

        <div class="row equal-tiles">
            <?php Blue2\Scruffy\Utils::archiveLoopOffsetOne('recipe'); ?>
        </div>

        <div class="row">
            <div class="col-12 pagination">
                <?= \Blue2\Scruffy\Site::customPagination(); ?>
            </div>
        </div>
        
    </div>
</section>