<?php
namespace Blue2\Scruffy\Post;

class Person extends \Blue2\Common\BasePost
{
    public function __construct()
    {
        parent::__construct();
    }

    public static function registerPostType()
    {
        $eventPostType = new \Blue2\Common\PostType("person");
        $eventPostType->register("Person", "People", [],
            [
                "menu_icon" => "dashicons-groups",
                "show_in_rest" => true, // Must be enabled for gutenberg support
                'rewrite' => array(
                    'slug' => 'people'
                )
            ]
        );
    }

    public static function registerTaxonomy()
    {
        $personTaxonomy = new \Blue2\Common\Taxonomy("area-of-expertise", "Area of Expertise", "Areas of Expertise", "person",
            [
                "show_in_rest" => true, // Must be enabled for gutenberg support
            ]
        );
    }
}