<?php
if($pattern == 'blog-post' || $pattern == 'person' || $pattern == 'product') {
	global $post;
	if($pattern == 'blog-post' && get_sub_field('blog')) {
		$post = get_sub_field('blog');
	} elseif($pattern == 'person' && get_sub_field('person')) {
		$post = get_sub_field('person');
	} elseif($pattern == 'product' && get_sub_field('product')) {
		$post = get_sub_field('product');
	}
	setup_postdata( $post ); 
	$label = 'View More';
	$url = get_the_permalink();
	$title = get_the_title();
	$caption = wp_trim_words(get_the_content(), 18, '...');
	$productImageId = get_post_thumbnail_id();
} elseif ($pattern == 'video') {
	$label = get_sub_field('call_to_action_label');
	$url = get_sub_field('call_to_action_url');
	$video = get_sub_field('video');
	$productImageId = "true";
	$topCircleIcon = get_sub_field('top_circle_icon');
} else {
	$label = get_sub_field('call_to_action_label');
	$url = get_sub_field('call_to_action_url');
	$title = get_sub_field('title');
	$caption = get_sub_field('caption');
	$productImageId = get_sub_field('image');
}

$productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'general-tile') : false;
$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: $title;
if($productImage !== false || isset($video)) {
?>
	<figure class="tile tile--caption tile--img-hover <?php if($pattern == 'product') { echo'tile--white-bg'; }?>">
		<?php if($label && $url) { ?>
			<a href="<?= $url; ?>">
				<span class="cta btn-graphic"><?= $label; ?></span>
		<?php } ?>

			<?php 
			if (!isset($video)) {
			?>
				<img class="img-fluid" src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
			<?php 
			} else {
			?>
				<video class="img-fluid" autoplay><source src="<?= $video ?>" type="video/mp4"> </video>
			<?php 
			} 
			?>

			<?php 
				if (!isset($video)) {
			?>
				<figcaption class="tile--caption--text">
					<?php if($title) { ?>
						<h3><?= $title; ?></h3>
					<?php } ?>

					<?php if($caption) { ?>
						<p><?= $caption; ?></p>
					<?php } ?>
				</figcaption>
			<?php } ?>

			<?php if($label && $url) { ?>
				</a>
			<?php } ?>
	</figure>
<?php } wp_reset_postdata();