<?php
namespace Blue2\Scruffy\Post;

class Store extends \Blue2\Common\BasePost
{
    public function __construct()
    {
        parent::__construct();
    }

    public static function registerPostType()
    {
        $eventPostType = new \Blue2\Common\PostType("store");
        $eventPostType->register("Store", "Stores", [],
            [
                "menu_icon" => "dashicons-store",
                "show_in_rest" => true, // Must be enabled for gutenberg support
                "has_archive" => false,
                "exclude_from_search" => true,
                "show_in_nav_menus" => false,
                "rewrite" => false,
                "public" => false
            ]
        );
    }

    public static function registerTaxonomy()
    {
        $personTaxonomy = new \Blue2\Common\Taxonomy("group", "Group", "Groups", "store",
            [
                "show_in_rest" => true, // Must be enabled for gutenberg support
            ]
        );

        $productTaxonomy = new \Blue2\Common\Taxonomy("product-group", "Product Group", "Product Groups", "store",
            [
                "show_in_rest" => true, // Must be enabled for gutenberg support
            ]
        );
    }
}