<?php $image = get_sub_field('background_image') ? wp_get_attachment_image_src(get_sub_field('background_image'), 'fullwidth-banner') : ['']; ?>

<section class="cac-flex-3-section">
    <div class="cac-flex-3-col-tile" id="flex-3-col-tile" style="background-image:url(' <?= $image[0]; ?>');">
        <div class="container">
            <?php if(get_sub_field('title')) { ?>
                <h2 class="accent"><?php the_sub_field('title'); ?></h2>
            <?php } ?>

            <?php if(get_sub_field('subtitle')) { ?>
                <h3><?php the_sub_field('subtitle'); ?></h3>
            <?php } ?>

            <?php if(have_rows('tile')) { ?>
                <div class="three-col-tile-wrapper">
                    <div class="row">
                        <?php 
                        while(have_rows('tile')) { 
                            the_row(); 
                        
                            $image = get_sub_field('image') ? wp_get_attachment_image_src(get_sub_field('image'), 'general-tile') : [''];
                            ?>

                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="three-col-tile-padding">
                                    <?php 
                                    switch (get_sub_field('tile_pattern')) {
                                        case 'free-form':
                                            include(locate_template('templates/parts/cac-tile-caption-marketing.php'));
                                            break;
                                        case 'image':
                                            include(locate_template('templates/parts/cac-tile-basic.php'));
                                            break;
                                        case 'product':
                                            include(locate_template('templates/parts/cac-tile-caption.php'));
                                            break;
                                    }
                                    ?>
                                </div>
                            </div>

                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
            
            
        </div>
    </div>
</section>