<?php

namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\StoreController;
use Blue2\Scruffy\Controllers\WoocommerceController;
use Blue2\Scruffy\Post\Store;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_action('after_setup_theme', [$this, 'customImageSizes']);
        add_action('admin_menu', [$this, 'customAdminPages']);

        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_filter('found_posts', [$this,'ajustOffsetPagination'], 1, 2 );

        add_filter('mce_buttons', [$this, 'updateMCEButtons']);
        add_filter('tiny_mce_before_init', [$this,'customMCEBeforeInit'] );
        add_action( 'template_redirect', [$this, 'singleRedirects'], 99 );
        add_action( 'wp_footer', [$this, 'WPCF7Event'] );

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();

        add_filter('woe_get_order_value_shop_name', [$this, 'getShopName'],10,3);
        add_filter('woe_get_order_value_pickup_date', [$this, 'getCollectionDate'],10,3);
        add_filter( 'woocommerce_checkout_fields' , [$this, 'customOverrideCheckoutFields'] );

        add_action('quick_edit_custom_box',  [$this, 'wpar_add_quick_edit'], 10, 2);
        add_action('save_post_product', [$this, 'wpar_quick_edit_save']);
        add_action('admin_print_footer_scripts-edit.php', [$this, 'wpar_quick_edit_js']);
    }

    function updateMCEButtons($buttons)
    {
        array_unshift( $buttons, 'styleselect' );
        return $buttons;
    }

    // Adding format buttons to wysiwyg
    function customMCEBeforeInit($init_array)
    {
        $style_formats = [
            [
                'title' => 'Accent h2',
                'block' => 'h2',
                'classes' => 'accent',
            ],
            [
                'title' => 'Accent h3',
                'block' => 'h3',
                'classes' => 'accent',
            ],
            [
                'title' => 'Accent h4',
                'block' => 'h4',
                'classes' => 'accent',
            ],
            [
                'title' => 'Branded bullet points',
                'selector' => 'ul',
                'classes' => 'brand',
            ],

        ];

        $init_array['style_formats'] = json_encode( $style_formats );

        return $init_array;
    }


    function WPCF7Event() {
        ?>
        <script type="text/javascript">
            document.addEventListener( 'wpcf7mailsent', function( event ) {
                gtag('event', 'Form Submitted', {'event_category':'company page', 'event_label': 'Contact form'});
            }, false );
        </script>
        <?php
    }

    /** May need refactoring if any other post types used are being paginated */
    function ajustOffsetPagination($found_posts, $query)
    {
        $offset = 1;
        // Make a check around this to make sure it is only applied for required post types
        return $found_posts - $offset;

        return $found_posts;
    }

    function singleRedirects()
    {
        if (is_singular('person')) {
            wp_redirect(home_url('people', 'relative'));
            die();
        }
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters()
    {
        add_filter('acf/fields/google_map/api', [$this, 'acfApiKey']);
        add_filter('acf/fields/taxonomy/wp_list_categories/name=supermarket_category_taxonomy', [$this,'populateSupermarketTaxonomy']);
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('pre_get_posts', [$this, 'vacancyArchivePosts']);
    }

    private function setupControllers()
    {
        new WoocommerceController();
        new StoreController();
    }

    public static function customPagination()
    {
        global $wp_query;

        echo paginate_links([
            'base' => str_replace(99999999, '%#%', esc_url(get_pagenum_link(99999999))),
            'format' => '?paged=%#%',
            'current' => max(1, get_query_var('paged')),
            'total' => $wp_query->max_num_pages,
        ]);
    }

    public static function getTile($pattern)
    {
        switch ($pattern) {
            case 'free-form':
                get_template_part('templates/parts/tile-caption-marketing');
                break;
            case 'image':
            case 'link-to-video':
            case 'accreditation':
                include(locate_template('templates/parts/tile-basic.php'));
                break;
            case 'blog-post':
            case 'person':
            case 'product':
                include(locate_template('templates/parts/tile-caption.php'));
                break;
            case 'recipe':
                get_template_part('templates/parts/tile-caption-recipe');
                break;
            case 'free-space':
                get_template_part('templates/parts/text-panel');
                break;
            case 'accordion':
                get_template_part('templates/parts/accordion-panel');
                break;
            case 'single-social-media':
                get_template_part('templates/parts/single-social-media');
                break;
            case 'social-media':
                $count = 3;
                echo "<div class='social-stream d-none d-xl-block'>";
                include(locate_template('templates/parts/social-media-menu.php'));
                echo "</div>";
                break;
        }
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'click_collect_menu' => 'Click and Collect Menu',
            'hamburger_menu_supermarkets' => 'Hamburger Menu Supermarkets',
            'hamburger_menu_local_butchers' => 'Hamburger Menu Loacl Butchers',
            'hamburger_menu_our_company' => 'Hamburger Menu Our Company',
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';

    }

    public function registerPostTypes()
    {
        Post\Person::registerPostType();
        Post\Recipe::registerPostType();
        Post\Accreditation::registerPostType();
        Post\Job::registerPostType();
        Post\Review::registerPostType();
        Post\Store::registerPostType();
        Post\SocialMedia::registerPostType();
    }

    public function registerTaxonomies()
    {
        Post\Person::registerTaxonomy();
        Post\Recipe::registerTaxonomy();
        Post\Store::registerTaxonomy();
        Post\Job::registerTaxonomy();
        Post\Review::registerTaxonomy();
    }

    public function customImageSizes()
    {
        add_image_size('general-tile', 800, 605, true);
        add_image_size('thin-tile', 920, 395, true);
        add_image_size('news-archive', 470, 360, true);
        add_image_size('news-archive-upd', 470, 370, true);
        add_image_size('news-single', 960);
        add_image_size('award-square', 200, 200, true);
        add_image_size('product-square', 700, 700, true);
        add_image_size('portrait-advert', 800, 1407, true);
        add_image_size('fullwidth-banner', 1980, 1200, true);
        add_image_size('ad-vacancy', 950, 85, true);
        add_image_size('fluid-length', 800); // height will be recalculated to keep the dimensions
        add_image_size('fullwidth', 1920); // height will be recalculated to keep the dimensions
    }

    public function customAdminPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'page_title' => 'Supermarket Archive',
                'parent' => 'edit.php?post_type=product',
                'capability' => 'edit_posts',
            ]);
            acf_add_options_page([
                'page_title' => 'Supermarket Header',
                'parent' => 'edit.php?post_type=product',
                'capability' => 'edit_posts',
            ]);

            acf_add_options_page([
                'page_title' => 'Click & Collect Archive',
                'parent' => 'edit.php?post_type=product',
                'capability' => 'edit_posts',
            ]);

            acf_add_options_page([
                'page_title' => 'Delivery Settings',
                'parent' => 'edit.php?post_type=product',
                'capability' => 'edit_posts',
            ]);

            acf_add_options_page([
                'title' => 'Recipe Archive',
                'parent' => 'edit.php?post_type=recipe',
                'capability' => 'edit_posts',
            ]);

            acf_add_options_page([
                'title' => 'Archive Settings',
                'parent' => 'edit.php',
                'capability' => 'edit_posts',
                'menu_slug' => 'acf-options-news-settings'
            ]);

            acf_add_options_page([
                'title' => 'Job Settings',
                'parent' => 'edit.php?post_type=job',
                'capability' => 'edit_posts',
            ]);
            acf_add_options_page([
                'title' => 'People Archive',
                'parent' => 'edit.php?post_type=person',
                'capability' => 'edit_posts',
            ]);
            acf_add_options_page([
                'title' => 'Email Templates',
                'capability' => 'edit_posts',
                'icon_url' => 'dashicons-email-alt'
            ]);
        }
    }

    public function acfApiKey($api)
    {
        $api['key'] = 'AIzaSyAGsKZ5PP8iURMpB4kRQKcpLQps-szGeqw';
        // TODO: SIMON HOWIE KEY, NOT ACTIVE YET
//        $api['key'] = 'AIzaSyBL-BESfZ6rPCgsN2ypgor4vfU-_TuUZoQ';
        return $api;

    }

    function vacancyArchivePosts($query)
    {
        if (!is_admin() && is_post_type_archive('job') && $query->is_main_query()) {
            $query->set('posts_per_page', -1);
        }
    }
    public function populateSupermarketTaxonomy($field) {

        $supermarketTerm = get_term_by('name', 'supermarket', 'product_cat');
        $field["parent"] = $supermarketTerm->term_id;

        return $field;
    }

    function getShopName ($value, $order, $fieldname) {
        $shipping = WoocommerceController::getShippingDetails($order);
        if ($shipping) {
            return $shipping['Pickup Location'];
        }
    }

    function getCollectionDate ($value, $order, $fieldname) {
        $shipping = WoocommerceController::getShippingDetails($order);
        if ($shipping) {
            return $shipping['Pickup Date'];
        }
    }

    function customOverrideCheckoutFields( $fields ) {
        $fields['order']['order_comments']['placeholder'] = 'Notes about your order, e.g. special notes for delivery or a request for items not listed online';
        return $fields;
    }

    function wpar_add_quick_edit($column_name, $post_type)
    {
        if (!($column_name === '5f103796d633d' || $column_name === '623b30a16d536')) return;

        // # Note
        // The class names that use with fieldset tag, 
        // it can be inline-edit-col-left, inline-edit-col-center and inline-edit-col-right.
        // 
        // # Trick: You can use the inspection tool from your browser to see what classes the admin page uses in the quick edit box.
        ?>

        <?php
        switch ($column_name) {
            case '5f103796d633d':
            case '623b30a16d536':

                // We keeps all our custom fields inside the <fieldset>
                // # a first column then print out the fieldset tag here.
                echo '<fieldset class="inline-edit-col-right" style="border: 1px solid #dddddd;">
                        <legend style="font-weight: bold; margin-left: 10px;">Custom Fields:</legend>
                        <div class="inline-edit-col">';


                // # note that, wp_nonce_field() must add it here at the first custom column. DO NOT add outside the switch().
                // Otherwise wp_nonce_field() will render every time that quick_edit_custom_box action hook is called for each column.
                wp_nonce_field('wpar_q_edit_nonce', 'wpar_nonce');
                echo '<label class="alignleft" style="width: 100%;">
                        <span class="title">' . __('Sorting Order', 'your-textdomain') . '</span>
                        <span class="input-text-wrap"><input type="url" name="Sorting Order" value="" style="width: 100%;"></span>
                        <span style="font-style: italic;color:#999999; text-align:right; display: inherit;">Enter the website URL</span>
                      </label>';
                echo '<br><br>';
                // # a last column then print out the end tags of fieldset here.      
                echo '</div></fieldset>';
                break;
            default:
                break;
        }
    }

    function wpar_quick_edit_save($post_id)
    {
        // # For quick edits use $_POST for storing the data.

        // If it is autosave, we don't do anything.
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
            return $post_id;


        // check user capabilities
        if (
            !current_user_can('edit_post', $post_id)
        ) {
            return;
        }

        // check nonce
        if (
            !wp_verify_nonce($_POST['wpar_nonce'], 'wpar_q_edit_nonce')
        ) {
            return;
        }

        // update the website
        if (
            isset($_POST['Sorting_Order'])
        ) {
            update_post_meta($post_id, 'sorting_order', $_POST['Sorting_Order']);
            update_field( "sorting_order", $_POST['Sorting_Order'], $post_id );
        }
    }

    function wpar_quick_edit_js()
    {
        $current_screen = get_current_screen();

        if ($current_screen->id != 'edit-product' || $current_screen->post_type !== 'product') {
            return;
        }

        wp_enqueue_script('jquery');
        ?>

        <!-- add JS script -->
        <script type="text/javascript">
            jQuery(function($) {
                console.log("heretesttest");

                // we create a copy of the WP inline edit post function
                var $wpar_inline_editor = inlineEditPost.edit;

                // Note: Hooking inlineEditPost.edit must be done in a JS script, loaded after wp-admin/js/inline-edit-post.js
                // then we overwrite the inlineEditPost.edit function with our own code
                inlineEditPost.edit = function(id) {

                    // call the original WP edit function 
                    $wpar_inline_editor.apply(this, arguments);


                    // ### start: add our custom functionality below  ###

                    // get the post ID
                    var $post_id = 0;
                    if (typeof(id) == 'object') {
                        $post_id = parseInt(this.getId(id));
                    }

                    // if we have our post
                    if ($post_id != 0) {

                        // define the edit row
                        var $edit_row = $('#edit-' + $post_id);
                        var $post_row = $('#post-' + $post_id);

                        // get the data
                        if ($('.column-5f103796d633d').length) {
                            var $website = $('.column-5f103796d633d', $post_row).text();
                        }
                        if ($('.column-623b30a16d536').length) {
                            var $website = $('.column-623b30a16d536', $post_row).text();
                        }

                        // populate the data
                        $(':input[name="Sorting Order"]', $edit_row).val($website);
                    }

                    // ### end: add our custom functionality below  ###
                }

            });
        </script>
    <?php
    }
}
