<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $post, $product;
$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$thumbnail_size    = apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' );
$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, $thumbnail_size );
$placeholder       = has_post_thumbnail() ? 'with-images' : 'without-images';
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'woocommerce-product-gallery--' . $placeholder,
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );

$additionalClasses = get_field('special_offer') == true ? "product_special_offer " : "";
$additionalClasses = get_field('requires_pre_payment') == true ? "product_limited_availability " : "";

?>

<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?> <?= $additionalClasses; ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
	<figure class="woocommerce-product-gallery__wrapper">
		<?php
		$attributes = array(
			'title'                   => get_post_field( 'post_title', $post_thumbnail_id ),
			'data-caption'            => get_post_field( 'post_excerpt', $post_thumbnail_id ),
			'data-src'                => $full_size_image[0],
			'data-large_image'        => $full_size_image[0],
			'data-large_image_width'  => $full_size_image[1],
			'data-large_image_height' => $full_size_image[2],
		);

		if ( has_post_thumbnail() ) {
			$category = Blue2\Scruffy\Controllers\WoocommerceController::checkRelatedCategory();
			$imageType = is_product() && $category === 'supermarket' ? 'general-tile' : 'shop_single';
			$html  = '<div data-thumb="' . get_the_post_thumbnail_url( $post->ID, 'shop_thumbnail' ) . '" class="woocommerce-product-gallery__image"><a href="' . esc_url( $full_size_image[0] ) . '">';
			$html .= get_the_post_thumbnail( $post->ID, $imageType, $attributes );
			$html .= '</a></div>';
		} else {
			$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
			$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
			$html .= '</div>';
		}

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, get_post_thumbnail_id( $post->ID ) );

		do_action( 'woocommerce_product_thumbnails' );

		if(get_field('available_at_butchers')) {	
			$url = get_field('click_and_collect_url') ?: esc_url(home_url('/')) . "click-and-collect/";
		?>
			<a class="award-link" href="<?= $url; ?>">
				<img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/dist/images/available-click-and-collect-badge.svg" alt="Available for Click & Collect in Perth or Auchterarder" />
			</a>
		<?php
		}
		if(get_field('related_award')) {
			$award = get_field('related_award');
			$awardImageId = get_field('smaller_icon', $award) ?: get_post_thumbnail_id($award);
			$awardImage = wp_get_attachment_image_src($awardImageId, 'thumbnail');
			$awardImageAlt = get_post_meta($awardImageId, '_wp_attachment_image_alt', true) ?: get_the_title($award);

			if($awardImage) { 
			?>
				<img class="award-thumb" src="<?= $awardImage[0]; ?>" alt="<?= $awardImageAlt; ?>" />
			<?php 
			} 
		}
		?>
        <a class="standout-link standout-link--write-a-review text-center" href="<?php echo esc_url(home_url('/')); ?>review-our-products/">
            <span class="hover-prompt">love this product?</span>
            <span class="lead-text"><span>sH</span>are your thoughts!</span>
        </a>
	</figure>
</div>
