<?php
namespace Blue2\Scruffy\Post;

class Review extends \Blue2\Common\BasePost
{
    public function __construct()
    {
        parent::__construct();
    }

    public static function registerPostType()
    {
        $reviewPostType = new \Blue2\Common\PostType("review");
        $reviewPostType->register("Review", "Reviews", [],
            [
                "menu_icon" => "dashicons-edit",
                "show_in_rest" => true, // Must be enabled for gutenberg support
                'rewrite' => array(
                    'slug' => 'reviews'
                )
            ]
        );
    }

    public static function registerTaxonomy()
    {
        $reviewTaxonomy = new \Blue2\Common\Taxonomy("review-grouping", "Review Grouping", "Review Groupings", "review",
            [
                "show_in_rest" => true, // Must be enabled for gutenberg support
            ]
        );
    }

}