<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );


$isLimitedProduct = false;
$isPrePaymentProduct = false;
if (get_field('limited_availability', get_the_ID()) == true) {
    $isLimitedProduct = true;
    if (get_field('requires_pre_payment', get_the_ID()) == true) {
        $isPrePaymentProduct = true;
    }
}
$datesRange = "";
if ($isLimitedProduct == true) {
    $allowOrderFrom = get_field('allow_order_from', $product_id);
    $allowOrderTo = get_field('allow_order_to', $product_id);
    $datesRange =  "Available dates: " . $allowOrderFrom . " - " . $allowOrderTo;
}
?>

	<div class="woocommerce-tabs wc-tabs-wrapper">
        <div id="accordion">
            <?php if(!empty(get_the_content())) { ?>
                <div class="card">
                    <div class="card-header" id="headingOne">
                        <h5 class="mb-0">
                            <button class="btn btn-link" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                Product Description
                                <i class="fas fa-angle-down"></i>
                                <?= $datesRange == "" ? "" : "<br><p>" . $datesRange . "</p>"; ?>
                            </button>
                        </h5>
                    </div>

                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordion">
                        <div class="card-body">
                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>
            <?php } ?>

            <?php
            if(have_rows('product_information_accordion')) {
                $count = 1;
                while(have_rows('product_information_accordion')) {
                    the_row();
                    $count++;
                    ?>
                    <div class="card">
                        <div class="card-header" id="heading<?= $count; ?>">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse<?= $count; ?>" aria-expanded="false" aria-controls="collapse<?= $count; ?>">
                                    <?php the_sub_field('accordion_label'); ?>
                                    <i class="fas fa-angle-down"></i>
                                </button>
                            </h5>
                        </div>
                        <div id="collapse<?= $count; ?>" class="collapse" aria-labelledby="heading<?= $count; ?>" data-parent="#accordion">
                            <div class="card-body">
                                <?php the_sub_field('accordion_text'); ?>
                            </div>
                        </div>
                    </div>
            <?php
                }
            }
            ?>
        </div>
	</div>
