<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<table class="shop_table woocommerce-checkout-review-order-table">
    <?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) { ?>
        <?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
        <?php wc_cart_totals_shipping_html(); ?>
        <?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
    <?php } ?>

    <tbody>
        <?php
            do_action( 'woocommerce_review_order_before_cart_contents' );
            $conflicts = false;
            $hasPrePaymentProduct = false;
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                $thumbnail    = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                $product_name = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
                $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->get_permalink(), $cart_item, $cart_item_key );

				$isLimitedProduct = false;
				$isPrePaymentProduct = false;
				if (get_field('limited_availability', $product_id) == true) {
					$isLimitedProduct = true;
					if (get_field('requires_pre_payment', $product_id) == true) {
						$isPrePaymentProduct = true;
                        $hasPrePaymentProduct = true;
					}
				}

                if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                     /** Check for chosen location */
                    $additionalClasses = Blue2\Scruffy\Controllers\WoocommerceController::checkProductLocation(get_field('available_location', $cart_item['product_id']));
                    if($additionalClasses == 'not-available') {
                        $conflicts = true;
                        Blue2\Scruffy\Controllers\WoocommerceController::addOverlayText($cart_item['product_id'], get_field('available_location', $cart_item['product_id'])[0]);
                    }

                    // $additionalClasses = Blue2\Scruffy\Controllers\WoocommerceController::checkProductAvailability($cart_item['product_id']);
                ?>
                    <tr class="<?= esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?> <?= $additionalClasses; ?> postId-<?= $cart_item['product_id']; ?>">
                    <?php if ( ! $_product->is_visible() ) { ?>
                        <td class="product-image">
                            <?= str_replace( array( 'http:', 'https:' ), '', $thumbnail )?>
                        </td>
                        <td class="product-name">
                            <?php echo $product_name; ?>
                        </td>
                    <?php } else { ?>
                        <td class="product-image">
                            <a href="<?= esc_url( $product_permalink ); ?>">
                                <?= str_replace( array( 'http:', 'https:' ), '', $thumbnail )?>
                            </a>
                        </td>
                        <td class="product-name">
                            <a href="<?= esc_url( $product_permalink ); ?>">
                                <?php echo $product_name; ?>
                            </a>
                            <span class="product-total">
                                <?= apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); ?>
                            </span>
                            <span class="product-data" >
                                <?php
                                $itemData = WC()->cart->get_item_data( $cart_item ) ? str_replace('Required', '', WC()->cart->get_item_data( $cart_item )) : '';
                                echo $itemData;

								if ($isLimitedProduct == true) {
                                    $allowOrderFrom = get_field('allow_order_from', $product_id);
                                    $allowOrderTo = get_field('allow_order_to', $product_id);
                                    echo "Available dates: " . $allowOrderFrom . " - " . $allowOrderTo;
                                }
								if ($isPrePaymentProduct == true) {
                                    echo "<br>This product requires prepayment.";
                                }
                                ?>
                            </span>
                            <span class="product-remove">
                            <?= apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
                                    '<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s">X</a>',
                                    esc_url( WC()->cart->get_remove_url( $cart_item_key ) ), __( 'Remove this item', 'woocommerce' ), esc_attr( $product_id ),
                                    esc_attr( $cart_item_key ), esc_attr( $_product->get_sku() ) ), $cart_item_key ); ?>
                            </span>
                        </td>
                    <?php } ?>

                    </tr>
                    <?php
                }
            }
        ?>
    </tbody>

    <tfoot>
        <tr class="order-total">
            <th>
                <?php _e( 'Basket Total:', 'woocommerce' ); ?>
            </th>

            <td>
                <?php
                    echo WC()->cart->get_cart_subtotal();
                ?>
            </td>
        </tr>
        <?php
        if(WC()->cart->get_coupons()) {
            $appliedCoupons = WC()->cart->get_applied_coupons(); ?>
            <?php
            $couponsActive = WC()->cart->get_coupons();
            foreach ($couponsActive as $activeCoupon) {
                $description .= $activeCoupon->get_description() . " ";
            }
            ?>
            <tr class="coupon-wrapper"><td colspan="2"><span class="coupon">Coupon <?= $appliedCoupons[0] ?> has been applied</span></td></tr>
            <tr class="coupon-wrapper"><td colspan="2"><span class="coupon"><?= $description; ?><strike><?= WC()->cart->get_cart_subtotal(); ?></strike>    £<?= number_format(WC()->cart->get_cart_contents_total(),2) ?></span><br><span class="coupon">You save: £<?= number_format(WC()->cart->get_cart_discount_total(),2) ?></span></td></tr>
        <?php } ?>
        <?php

        foreach( WC()->session->get('shipping_for_package_0')['rates'] as $method_id => $rate ){
            if( WC()->session->get('chosen_shipping_methods')[0] == $method_id ){
                if ($method_id == "flat_rate:4") {
        ?>
                <tr class="order-total">
                    <th class="checkout-deliver-text">
                        Delivery Charge
                    </th>

                    <td class="checkout-deliver-text">
                        <?php
                                $int_value = intval( WC()->cart->cart_contents_total );
                                if ($int_value >= 50) {
                                    ?>
                                    Free (for orders over £50)
                                    <?php
                                } else {
                                    ?>
                                    £3.99 (free over £50)
                                    <?php
                                }
                        ?>
                    </td>
                </tr>
        <?php
                }
            }
        }
        ?>
        <tr class="order-total">
            <th colspan="2">
                <?php _e( 'Approx:', 'woocommerce' ); ?>
                <?php wc_cart_totals_order_total_html(); ?>
                <?php
                if ($hasPrePaymentProduct) {
                    echo "<br><p class='pre-payment-message'>There is a product in your basket that requires prepayment. A member of the team will be in touch after you checkout.</p>";
                }
                ?>
            </th>
        </tr>
        <tr class="order-total">
            <td colspan="2">
                <?php if($conflicts === false) { ?>
                    <div class="wc-proceed-to-checkout">
                        <?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
                    </div>
                <?php } else { ?>
                    <div class="wc-proceed-to-checkout cart">
                        <a href="/cart/" class="checkout-button button alt wc-forward">View Cart</a>
                    </div>
                <?php } ?>
            </td>
        </tr>


        <?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
    </tfoot>
</table>
