<?php
$terms = wp_get_post_terms( get_the_ID(), 'department');
$date = new DateTime(get_field('closing_date', false, false));
?>
<article class="col-lg-6 vacancy-block">
    <div class="vacancy-content">
        <h2><?php the_title(); ?></h2>
        <span class="location"><strong>Location: </strong><?= get_field('location') . '<strong> | Closing Date: </strong>' . date_format($date, 'l jS \of F' ); ?></span>
        <?= !empty($terms) ? '<span class="department"><strong>Department:</strong>'.$terms[0]->name.'</span>' : ''; ?>
        <div class="excerpt"><?php the_excerpt(); ?></div>
        <a href="<?= get_the_permalink(); ?>" class="btn btn-apply-btn">Apply now</a>
    </div>
</article>