<?php 
$award = get_field('related_award');
$thumbnail = isset($count) && $count == 1 && isset($firstImg) && $firstImg == "thin" ? false : true;
$size = $thumbnail == false ? "thin-tile" : "general-tile";

if($thumbnail == false) {
	$productImageId = get_field('long_image');
	$productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'thin-tile') : 
		[get_template_directory_uri() . "/dist/images/default-800-605.jpg"];
	$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: 
		get_the_title();
} else {
	$productImageId = get_post_thumbnail_id();
	$productImage = has_post_thumbnail() ? wp_get_attachment_image_src($productImageId, 'general-tile') : 
				[get_template_directory_uri() . "/dist/images/default-800-605.jpg"];
	$productImageAlt = get_post_meta($productImageId, '_wp_attachment_image_alt', true) ?: get_the_title();
}
?>

<figure class="tile tile--caption tile--img-hover tile--dark">
	<a href="<?php the_permalink(); ?>">
		<span class="cta btn-graphic">View Product</span>

		<?php 
		if($award) {
			$awardImage = get_field('smaller_icon', $award) ?  wp_get_attachment_image_src(get_field('smaller_icon', $award), 'thumbnail') : wp_get_attachment_image_src(get_post_thumbnail_id($award), 'thumbnail');
			$awardImageAlt = get_post_meta(get_post_thumbnail_id($award), '_wp_attachment_image_alt', true) ?: get_the_title($award);
			if($awardImage) { 
			?>
				<img class="award-thumb" src="<?= $awardImage[0]; ?>" alt="<?= $awardImageAlt; ?>" />
			<?php 
			} 
		}

		if($productImage) {
		?>
			<img class="img-fluid" 
			srcset=""
			src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
		<?php } ?>
		<figcaption class="tile--caption--text">
            <h3><?php the_title(); ?></h3>
			<?= wp_trim_words(get_the_content(), 15, '...'); ?>
		</figcaption>
	</a>
</figure>