<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<table class="shop_table woocommerce-checkout-review-order-table">
    <?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) { ?>
        <?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
        <?php wc_cart_totals_shipping_html(); ?>
        <?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
    <?php } ?>

    <tbody>
        <?php
            do_action( 'woocommerce_review_order_before_cart_contents' );
            $conflicts = false;
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                $thumbnail    = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                // $product_name = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
                $product_name = $_product->get_name();
                $quantity = $cart_item['quantity'];
                $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->get_permalink(), $cart_item, $cart_item_key );

                if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                     /** Check for chosen location */
                    $additionalClasses = Blue2\Scruffy\Controllers\WoocommerceController::checkProductLocation(get_field('available_location', $cart_item['product_id']));
                    if($additionalClasses == 'not-available') {
                        $conflicts = true;
                        Blue2\Scruffy\Controllers\WoocommerceController::addOverlayText($cart_item['product_id'], get_field('available_location', $cart_item['product_id'])[0]);
                    }
                ?>
                    <tr class="<?= esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?> <?= $additionalClasses; ?> postId-<?= $cart_item['product_id']; ?>">
                    <?php if ( ! $_product->is_visible() ) { ?>
                        <td class="product-image">
                            <?= str_replace( array( 'http:', 'https:' ), '', $thumbnail )?>
                        </td>
                        <td class="product-name">
                            <?= $product_name; ?>
                        </td>
                        <td class="quantity">
                            Quantity: <?= $quantity; ?>
                        </td>
                    <?php } else { ?>
                        <td class="product-image">
                            <a href="<?= esc_url( $product_permalink ); ?>">
                                <?= str_replace( array( 'http:', 'https:' ), '', $thumbnail )?>
                            </a>
                        </td>
                        <td class="product-name">
                            <a href="<?= esc_url( $product_permalink ); ?>">
                                <?= $product_name; ?>
                            </a>
                            <span class="quantity">
                                Quantity: <?= $quantity; ?>
                             </span>
                            <span class="product-data" >
                                <?php
                                $itemData = WC()->cart->get_item_data( $cart_item ) ? str_replace('Required', '', WC()->cart->get_item_data( $cart_item )) : '';
                                echo $itemData;
                                ?>
                            </span>
                     
                            <span class="product-total">
                                <?= apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); ?>
                            </span>
                        </td>
                    <?php } ?>
                        
                    </tr>
                    <?php
                }
            }
        ?>
    </tbody>

    <tfoot>
        <tr class="order-total">
        <th><?php _e( 'Total', 'woocommerce' ); ?>
            <?php wc_cart_totals_order_total_html(); ?>
        </th>
        <td>
            <?php if($conflicts === false) { ?>
                <div class="wc-proceed-to-checkout">
                    <?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
                </div>
            <?php } else { ?>
                <div class="wc-proceed-to-checkout cart">
                    <a href="/cart/" class="checkout-button button alt wc-forward">View Cart</a>
                </div>
            <?php } ?>
        </td>
        </tr>


        <?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
    </tfoot>
</table>