<?php
namespace Blue2\Scruffy\Post;

class Recipe extends \Blue2\Common\BasePost
{
    public function __construct()
    {
        parent::__construct();
    }

    public static function registerPostType()
    {
        $recipePostType = new \Blue2\Common\PostType("recipe");
        $recipePostType->register("Recipe", "Recipes", [],
            [
                "menu_icon" => "dashicons-carrot",
                "show_in_rest" => true, // Must be enabled for gutenberg support
                'rewrite' => array(
                    'slug' => 'recipes'
                )
            ]
        );
    }

    public static function registerTaxonomy()
    {
        $timeTaxonomy = new \Blue2\Common\Taxonomy("time", "Filter time", "Filter time", "recipe",
            [
                "show_in_rest" => true, // Must be enabled for gutenberg support
            ]
        );

        $recipeTagsTaxonomy = new \Blue2\Common\Taxonomy("recipe_tag", "Tag", "Tags", "recipe",
            [
                "show_in_rest" => true, // Must be enabled for gutenberg support
            ]
        );
    }
}