<?php
$supermarket = get_term_by('slug', 'supermarket', 'product_cat');
$categories = get_field('supermarket_category_slider', 'option') ?: get_terms (['taxonomy' => 'product_cat', 'parent' => $supermarket->term_id]);

if($categories) {
    ?>
    <section class="section--nav section--product-slider-supermarket">
        <div class="swiper-container swiper-nav-supermarket">
            <div class="swiper-wrapper">
                <?php foreach($categories as $category) { 
                    $productImageId = get_woocommerce_term_meta( $category->term_id, 'thumbnail_id', true );
                    $productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'award-square') : [get_template_directory_uri() . "/dist/images/product-package-240-175.png"];
                    $productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: $category->name;
                    ?>

                    <div class="swiper-slide">
                        <a href="<?= get_term_link($category->term_id); ?>">
                            <img src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
                            <p><?= $category->name; ?></p>
                        </a>
                    </div>
                    
                <?php } ?>
            </div>
                <!-- Add Arrows -->
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <div class="mask"><a href="/where-to-buy"><i class="fas fa-map-marked-alt"></i>Where to buy map</a></div>
        </div>
    </section>
<?php }